/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.execution.StateBehaviors;

public abstract class EndingActivityWithBoundaryStateImpl
implements FlowNodeState {
    private final StateBehaviors stateBehaviors;

    public EndingActivityWithBoundaryStateImpl(StateBehaviors stateBehaviors) {
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        SActivityDefinition activityDef = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        return !activityDef.getBoundaryEventDefinitions().isEmpty();
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance instance) throws SActivityStateExecutionException {
        SActivityDefinition activityDef = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(instance.getFlowNodeDefinitionId());
        if (!activityDef.getBoundaryEventDefinitions().isEmpty()) {
            SActivityInstance activityInstance = (SActivityInstance)instance;
            this.stateBehaviors.interruptAttachedBoundaryEvent(processDefinition, activityInstance, this.getBoundaryCategoryState());
        }
        return StateCode.DONE;
    }

    public abstract SStateCategory getBoundaryCategoryState();

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    public StateBehaviors getStateBehaviors() {
        return this.stateBehaviors;
    }
}

