/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.expression.model.SExpression;

public class InitializingMultiInstanceActivityStateImpl
implements FlowNodeState {
    private final ExpressionResolverService expressionResolverService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final ActivityInstanceService activityInstanceService;
    private final StateBehaviors stateBehaviors;

    public InitializingMultiInstanceActivityStateImpl(ExpressionResolverService expressionResolverService, BPMInstancesCreator bpmInstancesCreator, ActivityInstanceService activityInstanceService, StateBehaviors stateBehaviors) {
        this.expressionResolverService = expressionResolverService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.activityInstanceService = activityInstanceService;
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SMultiInstanceActivityInstance multiInstanceActivityInstance = (SMultiInstanceActivityInstance)flowNodeInstance;
            this.stateBehaviors.createAttachedBoundaryEvents(processDefinition, multiInstanceActivityInstance);
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SActivityDefinition activity = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            SLoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
            this.bpmInstancesCreator.addChildDataContainer(multiInstanceActivityInstance);
            if (loopCharacteristics instanceof SMultiInstanceLoopCharacteristics) {
                SMultiInstanceLoopCharacteristics miLoop = (SMultiInstanceLoopCharacteristics)loopCharacteristics;
                SExpression loopCardinality = miLoop.getLoopCardinality();
                int numberOfInstanceMax = -1;
                if (loopCardinality != null) {
                    numberOfInstanceMax = (Integer)this.expressionResolverService.evaluate(loopCardinality, new SExpressionContext((Long)multiInstanceActivityInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId()));
                    this.activityInstanceService.setLoopCardinality(multiInstanceActivityInstance, numberOfInstanceMax);
                } else if (miLoop.getLoopDataInputRef() != null) {
                    numberOfInstanceMax = this.stateBehaviors.getNumberOfInstancesToCreateFromInputRef(processDefinition, multiInstanceActivityInstance, miLoop, numberOfInstanceMax);
                    this.stateBehaviors.updateOutputData(processDefinition, multiInstanceActivityInstance, miLoop, numberOfInstanceMax);
                }
                if (numberOfInstanceMax < 0) {
                    throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " did not have loop cardinality nor loop data input ref set");
                }
                this.stateBehaviors.createInnerInstances(processDefinition.getId(), activity, multiInstanceActivityInstance, miLoop.isSequential() ? 1 : numberOfInstanceMax);
            }
        }
        catch (SActivityStateExecutionException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
        return StateCode.DONE;
    }

    @Override
    public int getId() {
        return 27;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "initializing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

