/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SMessageInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ExecuteMessageCoupleWork
extends TenantAwareBonitaWork {
    private static final long serialVersionUID = 2171765554098439091L;
    private final long messageInstanceId;
    private final long waitingMessageId;

    ExecuteMessageCoupleWork(long messageInstanceId, long waitingMessageId) {
        this.messageInstanceId = messageInstanceId;
        this.waitingMessageId = waitingMessageId;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": messageInstanceId: " + this.messageInstanceId + ", waitingMessageId: " + this.waitingMessageId;
    }

    private void resetWaitingMessage(long waitingMessageId, EventInstanceService eventInstanceService) throws SWaitingEventModificationException, SWaitingEventReadException {
        SWaitingMessageEvent waitingMsg = eventInstanceService.getWaitingMessage(waitingMessageId);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).getProgressKey(), 0);
        eventInstanceService.updateWaitingMessage(waitingMsg, descriptor);
    }

    private void resetMessageInstance(long messageInstanceId, EventInstanceService eventInstanceService) throws SMessageModificationException, SMessageInstanceReadException {
        SMessageInstance messageInstance = eventInstanceService.getMessageInstance(messageInstanceId);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SMessageInstanceBuilderFactory.class).getHandledKey(), false);
        eventInstanceService.updateMessageInstance(messageInstance, descriptor);
    }

    @Override
    public String getRecoveryProcedure() {
        return "Change the 'progress' field of the waiting message having id " + this.waitingMessageId + " to " + 0 + " and " + "the 'handled' field of the message instance  having id " + this.messageInstanceId + " to false";
    }

    @Override
    public void work(Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        SWaitingMessageEvent waitingMessage = eventInstanceService.getWaitingMessage(this.waitingMessageId);
        SMessageInstance messageInstance = eventInstanceService.getMessageInstance(this.messageInstanceId);
        if (waitingMessage != null) {
            tenantAccessor.getEventsHandler().triggerCatchEvent(waitingMessage, this.messageInstanceId);
            eventInstanceService.deleteMessageInstance(messageInstance);
            dataInstanceService.deleteLocalDataInstances(this.messageInstanceId, DataInstanceContainer.MESSAGE_INSTANCE.name(), true);
        }
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        this.resetWaitingMessage(this.waitingMessageId, tenantAccessor.getEventInstanceService());
        this.resetMessageInstance(this.messageInstanceId, tenantAccessor.getEventInstanceService());
    }
}

