/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.execution.work.ExecuteFlowNodes;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.TransactionService;

public class RestartFlowNodesHandler
implements TenantRestartHandler {
    final Map<Long, List<Long>> flownodesToRestartByTenant = new HashMap<Long, List<Long>>();

    @Override
    public void beforeServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        try {
            long tenantId = tenantServiceAccessor.getTenantId();
            TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
            ArrayList<Long> flownodesToRestart = new ArrayList<Long>();
            this.flownodesToRestartByTenant.put(tenantId, flownodesToRestart);
            ActivityInstanceService flowNodeInstanceService = tenantServiceAccessor.getActivityInstanceService();
            QueryOptions queryOptions = new QueryOptions(0, 50000);
            List<Long> ids = null;
            this.logInfo(logger, "Restarting flow nodes...");
            do {
                ids = flowNodeInstanceService.getFlowNodeInstanceIdsToRestart(queryOptions);
                flownodesToRestart.addAll(ids);
                queryOptions = QueryOptions.getNextPage(queryOptions);
            } while (ids.size() == queryOptions.getNumberOfResults());
            this.logInfo(logger, "Found " + flownodesToRestart.size() + " flow nodes to restart on tenant " + tenantId);
        }
        catch (SBonitaReadException e) {
            throw new RestartException("unable to flag elements as to be restarted", e);
        }
    }

    private void logInfo(TechnicalLoggerService logger, String message) {
        boolean isInfo = logger.isLoggable(RestartFlowNodesHandler.class, TechnicalLogSeverity.INFO);
        if (isInfo) {
            logger.log(RestartFlowNodesHandler.class, TechnicalLogSeverity.INFO, message);
        }
    }

    @Override
    public void afterServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        TransactionService transactionService = platformServiceAccessor.getTransactionService();
        long tenantId = tenantServiceAccessor.getTenantId();
        List<Long> flownodesIds = this.flownodesToRestartByTenant.get(tenantId);
        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting " + flownodesIds.size() + " flow nodes for tenant " + tenantId);
        try {
            Iterator<Long> iterator = flownodesIds.iterator();
            do {
                transactionService.executeInTransaction(new ExecuteFlowNodes(tenantServiceAccessor, iterator));
            } while (iterator.hasNext());
        }
        catch (Exception e) {
            throw new RestartException("Unable to restart elements", e);
        }
    }
}

