/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work.failurewrapping;

import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.execution.work.failurewrapping.TxInHandleFailureWrappingWork;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.work.BonitaWork;

public class ProcessDefinitionContextWork
extends TxInHandleFailureWrappingWork {
    private static final long serialVersionUID = 6958842321501639910L;
    private long processDefinitionId;

    public ProcessDefinitionContextWork(BonitaWork wrappedWork, long processDefinitionId) {
        super(wrappedWork);
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    protected void setExceptionContext(SBonitaException sBonitaException, Map<String, Object> context) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessDefinitionDeployInfo processDeploymentInfo = processDefinitionService.getProcessDeploymentInfo(this.processDefinitionId);
        sBonitaException.setProcessDefinitionIdOnContext(this.processDefinitionId);
        sBonitaException.setProcessDefinitionNameOnContext(processDeploymentInfo.getName());
        sBonitaException.setProcessDefinitionVersionOnContext(processDeploymentInfo.getVersion());
    }

    public long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    protected void setProcessDefinitionId(long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }
}

