/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.ModelConvertor;

public class DocumentReferenceExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private final DocumentService documentService;
    private final FlowNodeInstanceService flowNodeInstanceService;

    public DocumentReferenceExpressionExecutorStrategy(DocumentService documentService, FlowNodeInstanceService flowNodeInstanceService) {
        this.documentService = documentService;
        this.flowNodeInstanceService = flowNodeInstanceService;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        return this.evaluate(Collections.singletonList(expression), context, resolvedExpressions, containerState).get(0);
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_DOCUMENT;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        Long containerId = (Long)context.get("containerId");
        String containerType = (String)context.get("containerType");
        Long time = (Long)context.get("time");
        try {
            long processInstanceId = this.getProcessInstance(containerId, containerType);
            ArrayList<Object> results = new ArrayList<Object>(expressions.size());
            for (SExpression expression : expressions) {
                results.add(this.getDocument(processInstanceId, expression, time));
            }
            return results;
        }
        catch (SExpressionDependencyMissingException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SExpressionEvaluationException((Throwable)e, null);
        }
    }

    private Document getDocument(long processInstanceId, SExpression expression, Long time) throws SBonitaReadException {
        try {
            SMappedDocument document = time != null ? this.documentService.getMappedDocument(processInstanceId, expression.getContent(), time) : this.documentService.getMappedDocument(processInstanceId, expression.getContent());
            return ModelConvertor.toDocument(document, this.documentService);
        }
        catch (SObjectNotFoundException e) {
            return null;
        }
    }

    private long getProcessInstance(Long containerId, String containerType) throws SFlowNodeNotFoundException, SFlowNodeReadException, SExpressionDependencyMissingException {
        if (containerId == null || containerType == null) {
            throw new SExpressionDependencyMissingException("The context to retrieve the document is not set.");
        }
        if (DataInstanceContainer.PROCESS_INSTANCE.name().equals(containerType)) {
            return containerId;
        }
        return this.flowNodeInstanceService.getFlowNodeInstance(containerId).getParentProcessInstanceId();
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

