/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.impl.AbstractGroovyScriptExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class GroovyScriptExpressionExecutorCacheStrategy
extends AbstractGroovyScriptExpressionExecutorStrategy {
    private static final String GROOVY_SCRIPT_CACHE_NAME = "GROOVY_SCRIPT_CACHE_NAME";
    private static final String SCRIPT_KEY = "SCRIPT_";
    private static final String SHELL_KEY = "SHELL_";
    private final CacheService cacheService;
    private final ClassLoaderService classLoaderService;
    private final TechnicalLoggerService logger;
    private final boolean debugEnabled;

    public GroovyScriptExpressionExecutorCacheStrategy(CacheService cacheService, ClassLoaderService classLoaderService, TechnicalLoggerService logger) {
        this.cacheService = cacheService;
        this.classLoaderService = classLoaderService;
        this.logger = logger;
        this.debugEnabled = logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG);
    }

    Script getScriptFromCache(String expressionContent, Long definitionId) throws SCacheException, SClassLoaderException {
        GroovyShell shell = this.getShell(definitionId);
        String key = Thread.currentThread().getId() + SCRIPT_KEY + definitionId + expressionContent.hashCode();
        Script script = (Script)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        if (script != null && script.getClass().getClassLoader().getParent() != shell.getClassLoader()) {
            ClassLoader classLoader = script.getClass().getClassLoader();
            script = null;
            this.cacheService.remove(GROOVY_SCRIPT_CACHE_NAME, key);
            if (this.debugEnabled) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Invalidating script because expected classloader <" + classLoader + "> but was <" + shell.getClassLoader() + ">");
            }
        }
        if (script == null) {
            script = shell.parse(expressionContent);
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), script);
        }
        return script;
    }

    GroovyShell getShell(Long definitionId) throws SClassLoaderException, SCacheException {
        String key = null;
        GroovyShell shell = null;
        if (definitionId != null) {
            key = SHELL_KEY + definitionId;
            shell = (GroovyShell)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        }
        if (shell == null) {
            ClassLoader classLoader = definitionId != null ? this.classLoaderService.getLocalClassLoader("PROCESS", definitionId) : Thread.currentThread().getContextClassLoader();
            if (this.debugEnabled) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Create a new groovy classloader for " + definitionId + " " + classLoader);
            }
            shell = new GroovyShell(classLoader);
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), shell);
        }
        return shell;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        String expressionName = expression.getName();
        try {
            Script script = this.getScriptFromCache(expressionContent, (Long)context.get("processDefinitionId"));
            Binding binding = new Binding(context);
            script.setBinding(binding);
            return script.run();
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expressionName).append(" with content = <").append(expressionContent).append("> depends on ").append(property).append(" is neither defined in the script nor in dependencies.");
            throw new SExpressionEvaluationException(builder.toString(), e, expressionName);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (SCacheException e) {
            throw new SExpressionEvaluationException("Problem accessing the Script Cache from GroovyScriptExpressionExecutorCacheStrategy.", e, expressionName);
        }
        catch (SClassLoaderException e) {
            throw new SExpressionEvaluationException("Unable to retrieve the correct classloader to execute the groovy script : " + expression, e, expressionName);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = "No message";
            }
            throw new SExpressionEvaluationException("Groovy script throws an exception of type " + e.getClass() + " with message = " + message + System.getProperty("line.separator") + "Expression : " + expression, e, expressionName);
        }
    }
}

