/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.incident;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentHandler;

public class FileLoggerIncidentHandler
implements IncidentHandler {
    private final String logFilePath;
    private final Map<Long, Logger> loggers;

    public FileLoggerIncidentHandler(String logFilePath) {
        this.logFilePath = logFilePath;
        this.loggers = new HashMap<Long, Logger>(2);
    }

    @Override
    public void handle(long tenantId, Incident incident) {
        try {
            Logger logger = this.getLogger(tenantId);
            logger.log(Level.SEVERE, "An incident occurred: " + incident.getDescription());
            logger.log(Level.SEVERE, "Exception was", incident.getCause());
            logger.log(Level.SEVERE, "We were unable to handle the failure on the elements because of", incident.getExceptionWhenHandlingFailure());
            String recoveryProcedure = incident.getRecoveryProcedure();
            if (recoveryProcedure != null && !recoveryProcedure.isEmpty()) {
                logger.log(Level.SEVERE, "Procedure to recover: " + recoveryProcedure);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Logger getLogger(long tenantId) throws SecurityException, IOException {
        Logger logger = this.loggers.get(tenantId);
        if (logger == null) {
            logger = Logger.getLogger("INCIDENT" + tenantId);
            FileHandler fh = new FileHandler(this.logFilePath + File.separatorChar + tenantId + File.separatorChar + "incidents.log");
            logger.addHandler(fh);
            SimpleFormatter formatter = new SimpleFormatter();
            fh.setFormatter(formatter);
            this.loggers.put(tenantId, logger);
        }
        return logger;
    }
}

