/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform;

import java.util.Collection;
import java.util.List;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.platform.exception.SDeletingActivatedTenantException;
import org.bonitasoft.engine.platform.exception.SPlatformAlreadyExistException;
import org.bonitasoft.engine.platform.exception.SPlatformCreationException;
import org.bonitasoft.engine.platform.exception.SPlatformDeletionException;
import org.bonitasoft.engine.platform.exception.SPlatformNotFoundException;
import org.bonitasoft.engine.platform.exception.SPlatformUpdateException;
import org.bonitasoft.engine.platform.exception.STenantActivationException;
import org.bonitasoft.engine.platform.exception.STenantAlreadyExistException;
import org.bonitasoft.engine.platform.exception.STenantCreationException;
import org.bonitasoft.engine.platform.exception.STenantDeactivationException;
import org.bonitasoft.engine.platform.exception.STenantDeletionException;
import org.bonitasoft.engine.platform.exception.STenantException;
import org.bonitasoft.engine.platform.exception.STenantNotFoundException;
import org.bonitasoft.engine.platform.exception.STenantUpdateException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.SPlatformProperties;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public interface PlatformService {
    public static final String TENANT = "TENANT";

    public SPlatform getPlatform() throws SPlatformNotFoundException;

    public void createPlatformTables() throws SPlatformCreationException, SPlatformAlreadyExistException;

    public void createPlatform(SPlatform var1) throws SPlatformCreationException;

    public void deletePlatform() throws SPlatformDeletionException, SPlatformNotFoundException;

    public void deletePlatformTables() throws SPlatformDeletionException;

    public void updatePlatform(SPlatform var1, EntityUpdateDescriptor var2) throws SPlatformUpdateException;

    public long createTenant(STenant var1) throws STenantCreationException, STenantAlreadyExistException;

    public void deleteTenant(long var1) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException;

    public void deleteTenantObjects(long var1) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException;

    public void updateTenant(STenant var1, EntityUpdateDescriptor var2) throws STenantUpdateException;

    public STenant getTenant(long var1) throws STenantNotFoundException;

    public STenant getTenantByName(String var1) throws STenantNotFoundException;

    public STenant getDefaultTenant() throws STenantNotFoundException;

    public List<STenant> getTenants(Collection<Long> var1, QueryOptions var2) throws STenantNotFoundException, STenantException;

    public boolean activateTenant(long var1) throws STenantNotFoundException, STenantActivationException;

    public void deactiveTenant(long var1) throws STenantNotFoundException, STenantDeactivationException;

    public int getNumberOfTenants() throws STenantException;

    public boolean isPlatformCreated();

    public List<STenant> searchTenants(QueryOptions var1) throws SBonitaReadException;

    public List<STenant> getTenants(QueryOptions var1) throws STenantException;

    public long getNumberOfTenants(QueryOptions var1) throws SBonitaReadException;

    public void deleteTenantTables() throws STenantDeletionException;

    public void createTenantTables() throws STenantCreationException;

    public void cleanTenantTables() throws STenantUpdateException;

    public void initializePlatformStructure() throws SPlatformCreationException;

    public SPlatformProperties getSPlatformProperties();
}

