/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.session.impl;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.platform.session.PlatformSessionProvider;
import org.bonitasoft.engine.platform.session.SSessionAlreadyExistsException;
import org.bonitasoft.engine.platform.session.SSessionNotFoundException;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;

public final class PlatformSessionProviderImpl
implements PlatformSessionProvider {
    private static Map<Long, SPlatformSession> platformSessions = new HashMap<Long, SPlatformSession>();

    @Override
    public synchronized void addSession(SPlatformSession session) throws SSessionAlreadyExistsException {
        long id = session.getId();
        if (platformSessions.containsKey(id)) {
            throw new SSessionAlreadyExistsException("A session wih id \"" + id + "\" already exists");
        }
        platformSessions.put(id, session);
    }

    @Override
    public void removeSession(long sessionId) throws SSessionNotFoundException {
        if (!platformSessions.containsKey(sessionId)) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
        platformSessions.remove(sessionId);
    }

    @Override
    public SPlatformSession getSession(long sessionId) throws SSessionNotFoundException {
        if (!platformSessions.containsKey(sessionId)) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
        return platformSessions.get(sessionId);
    }

    @Override
    public void updateSession(SPlatformSession session) throws SSessionNotFoundException {
        long id = session.getId();
        if (!platformSessions.containsKey(id)) {
            throw new SSessionNotFoundException("No session found with id \"" + id + "\"");
        }
        platformSessions.put(id, session);
    }
}

