/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorReadException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogCreationException;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.impl.SJobLogImpl;

public class JobLogCreator {
    private final JobService jobService;
    private final TechnicalLoggerService logger;

    public JobLogCreator(JobService jobService, TechnicalLoggerService logger) {
        this.jobService = jobService;
        this.logger = logger;
    }

    public void createJobLog(Exception jobException, Long jobDescriptorId) throws SJobLogCreationException, SJobDescriptorReadException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        if (jobDescriptor != null) {
            SJobLogImpl jobLog = new SJobLogImpl(jobDescriptorId);
            jobLog.setLastMessage(this.getStackTrace(jobException));
            jobLog.setRetryNumber(0L);
            jobLog.setLastUpdateDate(System.currentTimeMillis());
            this.jobService.createJobLog(jobLog);
        } else if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Impossible to mark the job with id '" + jobDescriptorId + "' as failed because no job was found for this identifier. It was probably removed just after its failure and before this action.");
        }
    }

    private String getStackTrace(Exception jobException) {
        StringWriter exceptionWriter = new StringWriter();
        jobException.printStackTrace(new PrintWriter(exceptionWriter));
        return exceptionWriter.toString();
    }
}

