/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.QueriableLogSessionProvider;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.services.QueriableLoggerStrategy;
import org.bonitasoft.engine.services.SQueriableLogException;
import org.bonitasoft.engine.services.SQueriableLogNotFoundException;
import org.bonitasoft.engine.services.impl.QueriableLogUpdater;

public abstract class AbstractQueriableLoggerImpl
implements QueriableLoggerService {
    private final PersistenceService persistenceService;
    private final QueriableLoggerStrategy loggerStrategy;
    protected final TechnicalLoggerService logger;
    private final QueriableLogUpdater logUpdater;

    public AbstractQueriableLoggerImpl(PersistenceService persistenceService, QueriableLoggerStrategy loggerStrategy, QueriableLogSessionProvider sessionProvider, PlatformService platformService, TechnicalLoggerService logger) {
        this.logger = logger;
        NullCheckingUtil.checkArgsNotNull(persistenceService, loggerStrategy, sessionProvider);
        this.persistenceService = persistenceService;
        this.loggerStrategy = loggerStrategy;
        this.logUpdater = new QueriableLogUpdater(sessionProvider, platformService, logger);
    }

    @Override
    public int getNumberOfLogs() throws SQueriableLogException {
        Map<String, Object> emptyMap = Collections.emptyMap();
        try {
            Long read = this.persistenceService.selectOne(new SelectOneDescriptor<Long>("getNumberOfLogs", emptyMap, SQueriableLog.class, Long.class));
            return read.intValue();
        }
        catch (SBonitaReadException e) {
            throw this.handleError("can't get the number of log", e);
        }
    }

    @Override
    public List<SQueriableLog> getLogs(int startIndex, int maxResults, String field, OrderByType order) throws SQueriableLogException {
        List<SQueriableLog> logs;
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SQueriableLog.class, field, order);
        try {
            logs = this.persistenceService.selectList(new SelectListDescriptor("getLogs", null, SQueriableLog.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw this.handleError("can't get logs", e);
        }
        return logs;
    }

    @Override
    public long getNumberOfLogs(QueryOptions searchOptions) throws SBonitaReadException {
        return this.persistenceService.getNumberOfEntities(SQueriableLog.class, searchOptions, null);
    }

    @Override
    public List<SQueriableLog> searchLogs(QueryOptions searchOptions) throws SBonitaReadException {
        return this.persistenceService.searchEntity(SQueriableLog.class, searchOptions, null);
    }

    @Override
    public void log(String callerClassName, String callerMethodName, SQueriableLog ... queriableLogs) {
        NullCheckingUtil.checkArgsNotNull(queriableLogs);
        ArrayList<SQueriableLog> loggableLogs = new ArrayList<SQueriableLog>();
        for (SQueriableLog log : queriableLogs) {
            if (!this.isLoggable(log.getActionType(), log.getSeverity())) continue;
            log = this.logUpdater.buildFinalLog(callerClassName, callerMethodName, log);
            loggableLogs.add(log);
        }
        if (loggableLogs.size() > 0) {
            this.log(loggableLogs);
        }
    }

    protected abstract void log(List<SQueriableLog> var1);

    @Override
    public boolean isLoggable(String actionType, SQueriableLogSeverity severity) {
        NullCheckingUtil.checkArgsNotNull(new Object[]{actionType, severity});
        return this.loggerStrategy.isLoggable(actionType, severity);
    }

    protected PersistenceService getPersitenceService() {
        return this.persistenceService;
    }

    protected QueriableLoggerStrategy getQueriableLogConfiguration() {
        return this.loggerStrategy;
    }

    @Override
    public SQueriableLog getLog(long logId) throws SQueriableLogNotFoundException, SQueriableLogException {
        try {
            SQueriableLog selectOne = this.persistenceService.selectById(new SelectByIdDescriptor<SQueriableLog>("getQueriableLogById", SQueriableLog.class, logId));
            if (selectOne == null) {
                throw new SQueriableLogNotFoundException(logId);
            }
            return selectOne;
        }
        catch (SBonitaReadException sbre) {
            throw new SQueriableLogException(sbre);
        }
    }

    private SQueriableLogException handleError(String message, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        return new SQueriableLogException(message, e);
    }
}

