/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.impl.AvailableOnStoppedNode;
import org.bonitasoft.engine.api.impl.NodeConfiguration;
import org.bonitasoft.engine.api.impl.PlatformAPIImplDelegate;
import org.bonitasoft.engine.api.impl.StarterThread;
import org.bonitasoft.engine.api.impl.scheduler.PlatformJobListenerManager;
import org.bonitasoft.engine.api.impl.scheduler.TenantJobListenerManager;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.GetTenantsCallable;
import org.bonitasoft.engine.api.impl.transaction.SetServiceState;
import org.bonitasoft.engine.api.impl.transaction.StartServiceStrategy;
import org.bonitasoft.engine.api.impl.transaction.StopServiceStrategy;
import org.bonitasoft.engine.api.impl.transaction.platform.ActivateTenant;
import org.bonitasoft.engine.api.impl.transaction.platform.CheckPlatformVersion;
import org.bonitasoft.engine.api.impl.transaction.platform.CleanPlatformTableContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteAllTenants;
import org.bonitasoft.engine.api.impl.transaction.platform.DeletePlatformContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeletePlatformTableContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteTenant;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteTenantObjects;
import org.bonitasoft.engine.api.impl.transaction.platform.GetPlatformContent;
import org.bonitasoft.engine.api.impl.transaction.platform.IsPlatformCreated;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.DefaultCommandProvider;
import org.bonitasoft.engine.command.SCommandAlreadyExistsException;
import org.bonitasoft.engine.command.SCommandCreationException;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandBuilderFactory;
import org.bonitasoft.engine.commons.PlatformLifecycleService;
import org.bonitasoft.engine.commons.RestartHandler;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.io.PropertiesManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.Platform;
import org.bonitasoft.engine.platform.PlatformNotFoundException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.PlatformState;
import org.bonitasoft.engine.platform.StartNodeException;
import org.bonitasoft.engine.platform.StopNodeException;
import org.bonitasoft.engine.platform.exception.SDeletingActivatedTenantException;
import org.bonitasoft.engine.platform.exception.STenantActivationException;
import org.bonitasoft.engine.platform.exception.STenantCreationException;
import org.bonitasoft.engine.platform.exception.STenantDeletionException;
import org.bonitasoft.engine.platform.exception.STenantNotFoundException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.platform.model.builder.SPlatformBuilderFactory;
import org.bonitasoft.engine.platform.model.builder.STenantBuilderFactory;
import org.bonitasoft.engine.profile.ImportPolicy;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.ProfilesImporter;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;
import org.bonitasoft.engine.transaction.STransactionException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.xml.Parser;

public class PlatformAPIImpl
implements PlatformAPI {
    private static final String STATUS_DEACTIVATED = "DEACTIVATED";
    private static final String PROFILES_FILE = "profiles.xml";
    private static boolean isNodeStarted = false;
    private final PlatformAPIImplDelegate delegate;

    public PlatformAPIImpl() {
        this.delegate = new PlatformAPIImplDelegate();
    }

    public PlatformAPIImpl(PlatformAPIImplDelegate delegate) {
        this.delegate = delegate;
    }

    protected PlatformAPIImplDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CustomTransactions
    @AvailableOnStoppedNode
    public void createPlatform() throws CreationException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new CreationException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        try {
            SPlatform platform = this.constructPlatform(platformAccessor);
            platformService.createPlatformTables();
            platformService.createTenantTables();
            transactionService.begin();
            try {
                platformService.initializePlatformStructure();
            }
            finally {
                transactionService.complete();
            }
            transactionService.begin();
            try {
                platformService.createPlatform(platform);
                platformService.getPlatform();
            }
            finally {
                transactionService.complete();
            }
        }
        catch (SBonitaException e) {
            throw new CreationException("Platform Creation failed.", (Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void initializePlatform() throws CreationException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new CreationException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        TechnicalLoggerService technicalLoggerService = platformAccessor.getTechnicalLoggerService();
        try {
            transactionService.begin();
            try {
                this.createDefaultTenant(platformAccessor, platformService, transactionService);
                this.activateDefaultTenant();
            }
            catch (Exception e) {
                if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
                }
                throw new CreationException("Platform initialisation failed.", (Throwable)e);
            }
            finally {
                transactionService.complete();
            }
        }
        catch (STransactionException e1) {
            throw new CreationException((Throwable)e1);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void createAndInitializePlatform() throws CreationException {
        this.createPlatform();
        this.initializePlatform();
    }

    protected PlatformServiceAccessor getPlatformAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
    }

    private SPlatform constructPlatform(PlatformServiceAccessor platformAccessor) {
        PlatformService platformService = platformAccessor.getPlatformService();
        String version = platformService.getSPlatformProperties().getPlatformVersion();
        String previousVersion = "";
        String initialVersion = version;
        String createdBy = "platformAdmin";
        long created = System.currentTimeMillis();
        return BuilderFactory.get(SPlatformBuilderFactory.class).createNewInstance(version, "", initialVersion, "platformAdmin", created).done();
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void startNode() throws StartNodeException {
        PlatformServiceAccessor platformAccessor;
        SessionAccessor sessionAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            sessionAccessor = this.createSessionAccessor();
        }
        catch (Exception e) {
            throw new StartNodeException((Throwable)e);
        }
        try {
            try {
                this.checkPlatformVersion(platformAccessor);
                List<STenant> tenants = this.getTenants(platformAccessor);
                this.startPlatformServices(platformAccessor);
                boolean mustRestartElements = !this.isNodeStarted();
                if (mustRestartElements) {
                    this.beforeServicesStartOfRestartHandlersOfTenant(platformAccessor, sessionAccessor, tenants);
                }
                this.startServicesOfTenants(platformAccessor, sessionAccessor, tenants);
                if (mustRestartElements) {
                    this.startScheduler(platformAccessor, tenants);
                    this.restartHandlersOfPlatform(platformAccessor);
                }
                isNodeStarted = true;
                if (mustRestartElements) {
                    this.afterServicesStartOfRestartHandlersOfTenant(platformAccessor, sessionAccessor, tenants);
                }
            }
            catch (SClassLoaderException e) {
                throw new StartNodeException("Platform starting failed while initializing platform classloaders.", (Throwable)e);
            }
            catch (SDependencyException e) {
                throw new StartNodeException("Platform starting failed while initializing platform classloaders.", (Throwable)e);
            }
            catch (StartNodeException sne) {
                throw sne;
            }
            catch (Exception e) {
                throw new StartNodeException("Platform starting failed.", (Throwable)e);
            }
            finally {
                this.cleanSessionAccessor(sessionAccessor, -1L);
            }
        }
        catch (StartNodeException e) {
            try {
                this.shutdownScheduler(platformAccessor);
            }
            catch (StartNodeException sne) {
                throw sne;
            }
            catch (Exception exp) {
                throw new StartNodeException("Platform stoping failed : " + exp.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    SessionAccessor createSessionAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        return ServiceAccessorFactory.getInstance().createSessionAccessor();
    }

    void afterServicesStartOfRestartHandlersOfTenant(PlatformServiceAccessor platformAccessor, SessionAccessor sessionAccessor, List<STenant> tenants) {
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        SessionService sessionService = platformAccessor.getSessionService();
        TechnicalLoggerService technicalLoggerService = platformAccessor.getTechnicalLoggerService();
        if (platformConfiguration.shouldResumeElements()) {
            new StarterThread(platformAccessor, sessionService, platformConfiguration, tenants, sessionAccessor, technicalLoggerService).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beforeServicesStartOfRestartHandlersOfTenant(PlatformServiceAccessor platformAccessor, SessionAccessor sessionAccessor, List<STenant> tenants) throws SessionIdNotSetException, SBonitaException, BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, BonitaHomeConfigurationException, IOException, Exception, SSessionNotFoundException {
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        SessionService sessionService = platformAccessor.getSessionService();
        if (platformConfiguration.shouldResumeElements()) {
            for (STenant tenant : tenants) {
                if (tenant.isPaused()) continue;
                long tenantId = tenant.getId();
                long sessionId = -1L;
                long platformSessionId = -1L;
                try {
                    platformSessionId = sessionAccessor.getSessionId();
                    sessionAccessor.deleteSessionId();
                    sessionId = this.createSessionAndMakeItActive(platformAccessor, sessionAccessor, tenantId);
                    this.beforeServicesStartOfRestartHandlersOfTenant(platformAccessor, tenantId);
                }
                finally {
                    sessionService.deleteSession(sessionId);
                    this.cleanSessionAccessor(sessionAccessor, platformSessionId);
                }
            }
        }
    }

    void restartHandlersOfPlatform(PlatformServiceAccessor platformAccessor) throws Exception {
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        for (final RestartHandler restartHandler : platformConfiguration.getRestartHandlers()) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    restartHandler.execute();
                    return null;
                }
            };
            platformAccessor.getTransactionService().executeInTransaction(callable);
        }
    }

    private void startScheduler(PlatformServiceAccessor platformAccessor, List<STenant> tenants) throws SBonitaException, BonitaHomeNotSetException, BonitaHomeConfigurationException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        if (platformConfiguration.shouldStartScheduler() && !schedulerService.isStarted()) {
            schedulerService.initializeScheduler();
            this.addPlatformJobListeners(platformAccessor, schedulerService);
            this.addTenantJobListeners(tenants, schedulerService);
            schedulerService.start();
        }
    }

    private void addTenantJobListeners(List<STenant> tenants, SchedulerService schedulerService) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (STenant tenant : tenants) {
            this.addTenantJobListener(schedulerService, tenant.getId());
        }
    }

    private void addTenantJobListener(SchedulerService schedulerService, long tenantId) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<AbstractBonitaTenantJobListener> jobListeners = this.getTenantServiceAccessor(tenantId).getTenantConfiguration().getJobListeners();
        TenantJobListenerManager tenantJobListenerManager = new TenantJobListenerManager(schedulerService);
        tenantJobListenerManager.registerListeners(jobListeners, tenantId);
    }

    private void addPlatformJobListeners(PlatformServiceAccessor platformAccessor, SchedulerService schedulerService) throws SSchedulerException {
        PlatformJobListenerManager platformJobListenerManager = new PlatformJobListenerManager(schedulerService);
        platformJobListenerManager.registerListener(platformAccessor.getPlatformConfiguration().getJobListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startServicesOfTenants(PlatformServiceAccessor platformAccessor, SessionAccessor sessionAccessor, List<STenant> tenants) throws Exception {
        SessionService sessionService = platformAccessor.getSessionService();
        for (STenant tenant : tenants) {
            long tenantId = tenant.getId();
            if (tenant.isPaused()) continue;
            long sessionId = -1L;
            long platformSessionId = -1L;
            try {
                platformSessionId = sessionAccessor.getSessionId();
                sessionAccessor.deleteSessionId();
                sessionId = this.createSessionAndMakeItActive(platformAccessor, sessionAccessor, tenantId);
                SetServiceState startService = new SetServiceState(tenantId, new StartServiceStrategy());
                platformAccessor.getTransactionService().executeInTransaction(startService);
            }
            finally {
                sessionService.deleteSession(sessionId);
                this.cleanSessionAccessor(sessionAccessor, platformSessionId);
            }
        }
    }

    void checkPlatformVersion(PlatformServiceAccessor platformAccessor) throws Exception {
        CheckPlatformVersion checkPlatformVersion;
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        if (!transactionService.executeInTransaction(checkPlatformVersion = new CheckPlatformVersion(platformService, BonitaHomeServer.getInstance())).booleanValue()) {
            throw new StartNodeException(checkPlatformVersion.getErrorMessage());
        }
    }

    void startPlatformServices(PlatformServiceAccessor platformAccessor) throws SBonitaException {
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        List<PlatformLifecycleService> servicesToStart = platformConfiguration.getLifecycleServices();
        for (PlatformLifecycleService serviceWithLifecycle : servicesToStart) {
            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Start service of platform : " + serviceWithLifecycle.getClass().getName());
            }
            if (serviceWithLifecycle.getClass().isInstance(schedulerService) && schedulerService.isStarted()) continue;
            serviceWithLifecycle.start();
        }
    }

    private void beforeServicesStartOfRestartHandlersOfTenant(final PlatformServiceAccessor platformAccessor, long tenantId) throws Exception {
        NodeConfiguration platformConfiguration = platformAccessor.getPlatformConfiguration();
        final TenantServiceAccessor tenantServiceAccessor = platformAccessor.getTenantServiceAccessor(tenantId);
        for (final TenantRestartHandler restartHandler : platformConfiguration.getTenantRestartHandlers()) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    restartHandler.beforeServicesStart(platformAccessor, tenantServiceAccessor);
                    return null;
                }
            };
            tenantServiceAccessor.getUserTransactionService().executeInTransaction(callable);
        }
    }

    protected List<STenant> getTenants(PlatformServiceAccessor platformAccessor) throws Exception {
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        return transactionService.executeInTransaction(new GetTenantsCallable(platformService));
    }

    protected TenantServiceAccessor getTenantServiceAccessor(long tenantId) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ServiceAccessorFactory.getInstance().createTenantServiceAccessor(tenantId);
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void stopNode() throws StopNodeException {
        try {
            PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
            NodeConfiguration nodeConfiguration = platformAccessor.getPlatformConfiguration();
            List<PlatformLifecycleService> otherServicesToStart = nodeConfiguration.getLifecycleServices();
            TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
            if (nodeConfiguration.shouldStartScheduler()) {
                this.shutdownScheduler(platformAccessor);
            }
            if (nodeConfiguration.shouldClearSessions()) {
                platformAccessor.getSessionService().deleteSessions();
            }
            List<STenant> tenantIds = this.getTenants(platformAccessor);
            for (STenant tenant : tenantIds) {
                platformAccessor.getTransactionService().executeInTransaction(new SetServiceState(tenant.getId(), new StopServiceStrategy()));
            }
            for (PlatformLifecycleService serviceWithLifecycle : otherServicesToStart) {
                logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Stop service of platform: " + serviceWithLifecycle.getClass().getName());
                serviceWithLifecycle.stop();
            }
            isNodeStarted = false;
        }
        catch (SBonitaException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (BonitaHomeNotSetException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (IOException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (BonitaHomeConfigurationException e) {
            throw new StopNodeException(e.getMessage());
        }
        catch (StopNodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StopNodeException((Throwable)e);
        }
    }

    private void shutdownScheduler(PlatformServiceAccessor platformAccessor) throws Exception {
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        if (this.isNodeStarted()) {
            schedulerService.stop();
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void cleanPlatform() throws DeletionException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        final CleanPlatformTableContent clean = new CleanPlatformTableContent(platformService);
        final DeleteAllTenants deleteAll = new DeleteAllTenants(platformService);
        try {
            transactionService.executeInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clean.execute();
                    deleteAll.execute();
                    return null;
                }
            });
        }
        catch (DeletionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void deletePlatform() throws DeletionException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
        final PlatformService platformService = platformAccessor.getPlatformService();
        TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
        DeletePlatformContent deletePlatformContent = new DeletePlatformContent(platformService);
        try {
            TransactionContent deleteTenantTables = new TransactionContent(){

                @Override
                public void execute() throws SBonitaException {
                    platformService.deleteTenantTables();
                }
            };
            transactionExecutor.execute(deletePlatformContent);
            transactionExecutor.execute(deleteTenantTables);
            DeletePlatformTableContent deletePlatformTableContent = new DeletePlatformTableContent(platformService);
            transactionExecutor.execute(deletePlatformTableContent);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void cleanAndDeletePlaftorm() throws DeletionException {
        this.cleanPlatform();
        this.deletePlatform();
    }

    @AvailableOnStoppedNode
    public Platform getPlatform() throws PlatformNotFoundException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        GetPlatformContent transactionContent = new GetPlatformContent(platformService);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        SPlatform sPlatform = transactionContent.getResult();
        return ModelConvertor.toPlatform(sPlatform);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDefaultTenant(PlatformServiceAccessor platformAccessor, PlatformService platformService, TransactionService transactionService) throws STenantCreationException {
        String tenantName = "default";
        String description = "Default tenant";
        String userName = "";
        SessionAccessor sessionAccessor = null;
        long platformSessionId = -1L;
        try {
            String createdBy = "defaultUser";
            STenant tenant = BuilderFactory.get(STenantBuilderFactory.class).createNewInstance("default", "defaultUser", System.currentTimeMillis(), STATUS_DEACTIVATED, true).setDescription("Default tenant").done();
            Long tenantId = platformService.createTenant(tenant);
            transactionService.complete();
            transactionService.begin();
            String targetDir = this.createTenantFolderInBonitaHome(tenant);
            userName = this.getUserName(tenant, tenantId, targetDir);
            TenantServiceAccessor tenantServiceAccessor = platformAccessor.getTenantServiceAccessor(tenantId);
            SessionService sessionService = platformAccessor.getSessionService();
            sessionAccessor = this.createSessionAccessor();
            SSession session = sessionService.createSession(tenantId, -1L, userName, true);
            platformSessionId = sessionAccessor.getSessionId();
            sessionAccessor.deleteSessionId();
            sessionAccessor.setSessionInfo(session.getId(), tenantId);
            this.createDefaultCommands(tenantServiceAccessor);
            this.createDefaultProfiles(tenantServiceAccessor);
            this.getDelegate().createDefaultThemes(tenantServiceAccessor);
            sessionService.deleteSession(session.getId());
            this.cleanSessionAccessor(sessionAccessor, platformSessionId);
            return;
        }
        catch (STenantCreationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new STenantCreationException("Unable to create default tenant", e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanSessionAccessor(sessionAccessor, platformSessionId);
                throw throwable;
            }
        }
    }

    private String getUserName(STenant tenant, Long tenantId, String targetDir) throws IOException, STenantDeletionException, STenantCreationException {
        try {
            return this.getUserName(tenantId);
        }
        catch (Exception e) {
            IOUtil.deleteDir(new File(targetDir));
            this.deleteTenant(tenant.getId());
            throw new STenantCreationException("Access File Exception !!");
        }
    }

    private String createTenantFolderInBonitaHome(STenant tenant) throws STenantDeletionException, STenantCreationException, IOException {
        String sourceDir;
        String targetDir;
        try {
            BonitaHomeServer home = BonitaHomeServer.getInstance();
            targetDir = home.getTenantsFolder() + File.separator + tenant.getId();
            sourceDir = home.getTenantTemplateFolder();
        }
        catch (BonitaHomeNotSetException e) {
            this.deleteTenant(tenant.getId());
            throw new STenantCreationException("Bonita home not set !!");
        }
        try {
            FileUtils.copyDirectory((File)new File(sourceDir), (File)new File(targetDir));
        }
        catch (IOException e) {
            IOUtil.deleteDir(new File(targetDir));
            this.deleteTenant(tenant.getId());
            throw new STenantCreationException("Copy File Exception !!");
        }
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultProfiles(TenantServiceAccessor tenantServiceAccessor) throws Exception {
        String xmlContent;
        Parser parser = tenantServiceAccessor.getProfileParser();
        ProfileService profileService = tenantServiceAccessor.getProfileService();
        IdentityService identityService = tenantServiceAccessor.getIdentityService();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getProfileFileName());
        if (inputStream == null) {
            return;
        }
        try {
            xmlContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        finally {
            inputStream.close();
        }
        List<ExportedProfile> profilesFromXML = ProfilesImporter.getProfilesFromXML(xmlContent, parser);
        this.importProfiles(profileService, identityService, profilesFromXML, tenantServiceAccessor);
    }

    protected void importProfiles(ProfileService profileService, IdentityService identityService, List<ExportedProfile> profilesFromXML, TenantServiceAccessor tenantServiceAccessor) throws ExecutionException {
        new ProfilesImporter(profileService, identityService, profilesFromXML, ImportPolicy.FAIL_ON_DUPLICATES).importProfiles(-1L);
    }

    protected void cleanSessionAccessor(SessionAccessor sessionAccessor, long platformSessionId) {
        if (sessionAccessor != null) {
            sessionAccessor.deleteSessionId();
            if (platformSessionId != -1L) {
                sessionAccessor.setSessionInfo(platformSessionId, -1L);
            }
        }
    }

    protected void createDefaultCommands(TenantServiceAccessor tenantServiceAccessor) throws SCommandAlreadyExistsException, SCommandCreationException {
        CommandService commandService = tenantServiceAccessor.getCommandService();
        DefaultCommandProvider provider = tenantServiceAccessor.getDefaultCommandProvider();
        SCommandBuilderFactory fact = BuilderFactory.get(SCommandBuilderFactory.class);
        for (CommandDescriptor command : provider.getDefaultCommands()) {
            SCommand sCommand = fact.createNewInstance(command.getName(), command.getDescription(), command.getImplementation()).setSystem(true).done();
            commandService.create(sCommand);
        }
    }

    private String getUserName(long tenantId) throws IOException, BonitaHomeNotSetException {
        String tenantPath = BonitaHomeServer.getInstance().getTenantConfFolder(tenantId) + File.separator + "bonita-server.properties";
        File file = new File(tenantPath);
        Properties properties = PropertiesManager.getProperties((File)file);
        return properties.getProperty("userName");
    }

    private void deleteTenant(long tenantId) throws STenantDeletionException {
        PlatformServiceAccessor platformAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            PlatformService platformService = platformAccessor.getPlatformService();
            TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
            TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
            DeleteTenantObjects transactionContentForTenantObjects = new DeleteTenantObjects(tenantId, platformService);
            transactionExecutor.execute(transactionContentForTenantObjects);
            DeleteTenant transactionContentForTenant = new DeleteTenant(tenantId, platformService);
            transactionExecutor.execute(transactionContentForTenant);
            TenantServiceAccessor tenantServiceAccessor = platformAccessor.getTenantServiceAccessor(tenantId);
            SetServiceState stopService = new SetServiceState(tenantId, new StopServiceStrategy());
            platformAccessor.getTransactionService().executeInTransaction(stopService);
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Destroy tenant context of tenant " + tenantId);
            tenantServiceAccessor.destroy();
            String targetDir = BonitaHomeServer.getInstance().getTenantsFolder() + File.separator + tenantId;
            IOUtil.deleteDir(new File(targetDir));
        }
        catch (STenantNotFoundException e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException(e);
        }
        catch (SDeletingActivatedTenantException e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException("Unable to delete an activated tenant " + tenantId);
        }
        catch (STenantDeletionException e) {
            this.log(platformAccessor, e);
            throw e;
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException(e);
        }
    }

    private void activateDefaultTenant() throws STenantActivationException {
        PlatformServiceAccessor platformAccessor = null;
        SessionAccessor sessionAccessor = null;
        long platformSessionId = -1L;
        try {
            platformAccessor = this.getPlatformAccessor();
            sessionAccessor = this.createSessionAccessor();
            STenant defaultTenant = this.getDefaultTenant();
            long tenantId = defaultTenant.getId();
            PlatformService platformService = platformAccessor.getPlatformService();
            SchedulerService schedulerService = platformAccessor.getSchedulerService();
            SessionService sessionService = platformAccessor.getSessionService();
            NodeConfiguration plaformConfiguration = platformAccessor.getPlatformConfiguration();
            this.startScheduler(platformAccessor, Arrays.asList(defaultTenant));
            platformSessionId = sessionAccessor.getSessionId();
            sessionAccessor.deleteSessionId();
            long sessionId = this.createSessionAndMakeItActive(platformAccessor, sessionAccessor, tenantId);
            TenantServiceAccessor tenantServiceAccessor = this.getTenantServiceAccessor(tenantId);
            ActivateTenant activateTenant = new ActivateTenant(tenantId, platformService, schedulerService, platformAccessor.getTechnicalLoggerService(), tenantServiceAccessor.getWorkService(), tenantServiceAccessor.getConnectorExecutor(), plaformConfiguration, tenantServiceAccessor.getTenantConfiguration());
            activateTenant.execute();
            sessionService.deleteSession(sessionId);
        }
        catch (STenantActivationException stae) {
            this.log(platformAccessor, stae);
            throw stae;
        }
        catch (STenantNotFoundException stnfe) {
            this.log(platformAccessor, stnfe);
            throw new STenantActivationException(stnfe);
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantActivationException(e);
        }
        finally {
            this.cleanSessionAccessor(sessionAccessor, platformSessionId);
        }
    }

    protected Long createSession(long tenantId, SessionService sessionService) throws SBonitaException {
        return sessionService.createSession(tenantId, "system").getId();
    }

    private void log(PlatformServiceAccessor platformAccessor, Exception e) {
        if (platformAccessor != null) {
            TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
        } else {
            e.printStackTrace();
        }
    }

    private long createSessionAndMakeItActive(PlatformServiceAccessor platformAccessor, SessionAccessor sessionAccessor, long tenantId) throws SBonitaException {
        SessionService sessionService = platformAccessor.getSessionService();
        long sessionId = this.createSession(tenantId, sessionService);
        sessionAccessor.setSessionInfo(sessionId, tenantId);
        return sessionId;
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public boolean isPlatformCreated() throws PlatformNotFoundException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
        IsPlatformCreated transactionContent = new IsPlatformCreated(platformService);
        try {
            transactionExecutor.execute(transactionContent);
            return (Boolean)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            TechnicalLoggerService technicalLoggerService = platformAccessor.getTechnicalLoggerService();
            if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
            return false;
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public PlatformState getPlatformState() {
        if (this.isNodeStarted()) {
            return PlatformState.STARTED;
        }
        return PlatformState.STOPPED;
    }

    private STenant getDefaultTenant() throws STenantNotFoundException {
        PlatformServiceAccessor platformAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            PlatformService platformService = platformAccessor.getPlatformService();
            return platformService.getDefaultTenant();
        }
        catch (STenantNotFoundException e) {
            this.log(platformAccessor, e);
            throw e;
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantNotFoundException("Unable to retrieve the defaultTenant.", e);
        }
    }

    @AvailableOnStoppedNode
    public boolean isNodeStarted() {
        return isNodeStarted;
    }

    protected String getProfileFileName() {
        return PROFILES_FILE;
    }

    public void rescheduleErroneousTriggers() throws UpdateException {
        try {
            PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
            platformAccessor.getSchedulerService().rescheduleErroneousTriggers();
        }
        catch (SSchedulerException sse) {
            throw new UpdateException((Throwable)sse);
        }
        catch (Exception e) {
            throw new UpdateException((Throwable)e);
        }
    }
}

