/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinitionWithInputValues;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.execution.Filter;
import org.bonitasoft.engine.execution.FlowNodeNameFilter;
import org.bonitasoft.engine.execution.FlowNodeSelector;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StartFlowNodeFilter;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class ProcessStarter {
    private final long userId;
    private final long processDefinitionId;
    private final List<Operation> operations;
    private final Map<String, Serializable> context;
    private final Filter<SFlowNodeDefinition> filter;

    private ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context, Filter<SFlowNodeDefinition> filter) {
        this.userId = userId;
        this.processDefinitionId = processDefinitionId;
        this.operations = operations;
        this.context = context;
        this.filter = filter;
    }

    public ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) {
        this(userId, processDefinitionId, operations, context, new StartFlowNodeFilter());
    }

    public ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context, List<String> activityNames) {
        this(userId, processDefinitionId, operations, context, new FlowNodeNameFilter(activityNames));
    }

    public ProcessInstance start() throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        try {
            return this.start(null);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new RetrieveException((Throwable)e);
        }
        catch (SProcessDefinitionException e) {
            throw new ProcessActivationException((Exception)e);
        }
        catch (SBonitaException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
    }

    public ProcessInstance start(List<ConnectorDefinitionWithInputValues> connectorsWithInput) throws SProcessInstanceCreationException, SProcessDefinitionReadException, SProcessDefinitionException {
        SProcessInstance startedSProcessInstance;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        SProcessDefinition sProcessDefinition = this.getProcessDefinition();
        Map<String, Object> operationContext = this.getContext();
        long starterSubstituteUserId = SessionInfos.getUserIdFromSession();
        long starterUserId = this.getStarterUserId(starterSubstituteUserId);
        try {
            List<SOperation> sOperations = ModelConvertor.convertOperations(this.operations);
            startedSProcessInstance = processExecutor.start(starterUserId, starterSubstituteUserId, sOperations, operationContext, connectorsWithInput, new FlowNodeSelector(sProcessDefinition, this.filter));
        }
        catch (SProcessInstanceCreationException e) {
            this.log(tenantAccessor, e);
            e.setProcessDefinitionIdOnContext(sProcessDefinition.getId());
            e.setProcessDefinitionNameOnContext(sProcessDefinition.getName());
            e.setProcessDefinitionVersionOnContext(sProcessDefinition.getVersion());
            throw e;
        }
        this.logProcessInstanceStartedAndAddComment(sProcessDefinition, starterUserId, starterSubstituteUserId, startedSProcessInstance);
        return ModelConvertor.toProcessInstance(sProcessDefinition, startedSProcessInstance);
    }

    protected void log(TenantServiceAccessor tenantAccessor, Exception e) {
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
    }

    protected long getStarterUserId(long starterSubstituteUserId) {
        if (this.userId == 0L) {
            return starterSubstituteUserId;
        }
        return this.userId;
    }

    protected Map<String, Object> getContext() {
        if (this.context != null) {
            return new HashMap<String, Object>(this.context);
        }
        return Collections.emptyMap();
    }

    private SProcessDefinition getProcessDefinition() throws SProcessDefinitionReadException, SProcessDefinitionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessDefinitionDeployInfo deployInfo = processDefinitionService.getProcessDeploymentInfo(this.processDefinitionId);
        if (ActivationState.DISABLED.name().equals(deployInfo.getActivationState())) {
            throw new SProcessDefinitionException("The process definition is not enabled !!", deployInfo.getProcessId(), deployInfo.getName(), deployInfo.getVersion());
        }
        return processDefinitionService.getProcessDefinition(this.processDefinitionId);
    }

    private void logProcessInstanceStartedAndAddComment(SProcessDefinition sProcessDefinition, long starterId, long starterSubstituteId, SProcessInstance sProcessInstance) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        StringBuilder stb = new StringBuilder();
        stb.append("The user <");
        stb.append(SessionInfos.getUserNameFromSession());
        if (starterId != starterSubstituteId) {
            stb.append("> acting as delegate of user with id <");
            stb.append(starterId);
        }
        stb.append("> has started the process instance <");
        stb.append(sProcessInstance.getId());
        stb.append("> of process <");
        stb.append(sProcessDefinition.getName());
        stb.append("> in version <");
        stb.append(sProcessDefinition.getVersion());
        stb.append("> and id <");
        stb.append(sProcessDefinition.getId());
        stb.append(">");
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, stb.toString());
        }
        this.addSystemCommentOnProcessInstanceWhenStartingProcessFor(sProcessInstance, starterId, starterSubstituteId);
    }

    protected void addSystemCommentOnProcessInstanceWhenStartingProcessFor(SProcessInstance sProcessInstance, long starterId, long starterSubstituteId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        SCommentService commentService = tenantAccessor.getCommentService();
        if (starterId != starterSubstituteId) {
            IdentityService identityService = tenantAccessor.getIdentityService();
            try {
                SUser starter = identityService.getUser(starterId);
                StringBuilder stb = new StringBuilder();
                stb.append("The user ").append(SessionInfos.getUserNameFromSession()).append(" ");
                stb.append("acting as delegate of the user ").append(starter.getUserName()).append(" ");
                stb.append("has started the case.");
                commentService.addSystemComment(sProcessInstance.getId(), stb.toString());
            }
            catch (SBonitaException e) {
                logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Error when adding a comment on the process instance.", e);
            }
        }
    }

    protected TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }
}

