/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.model.xml;

import java.util.List;
import org.bonitasoft.engine.core.category.model.xml.XMLCategoriesMapping;
import org.bonitasoft.engine.core.category.model.xml.XMLCategoryMapping;
import org.bonitasoft.engine.core.category.model.xml.XMLProcessDefinitionsMapping;
import org.bonitasoft.engine.xml.XMLNode;

public class CategoryMappingNodeBuilder {
    public static XMLNode getDocument(XMLCategoriesMapping xmlCategoriesMapping) {
        XMLNode document = CategoryMappingNodeBuilder.getRootNode();
        List<XMLCategoryMapping> categoryMappingList = xmlCategoriesMapping.getCategoryList();
        if (categoryMappingList != null) {
            for (XMLCategoryMapping categoryMapping : categoryMappingList) {
                document.addChild(CategoryMappingNodeBuilder.getCategoryNode(categoryMapping));
            }
        }
        return document;
    }

    public static XMLNode getCategoryNode(XMLCategoryMapping xmlCategoryMapping) {
        XMLNode categoryMapping = new XMLNode("category");
        categoryMapping.addAttribute("name", xmlCategoryMapping.getName());
        XMLNode description = CategoryMappingNodeBuilder.getSubNode("description", xmlCategoryMapping.getDescription());
        categoryMapping.addChild(description);
        XMLNode creator = CategoryMappingNodeBuilder.getSubNode("creator", xmlCategoryMapping.getCreator());
        categoryMapping.addChild(creator);
        XMLNode creationDate = CategoryMappingNodeBuilder.getSubNode("creationDate", xmlCategoryMapping.getCreationDate());
        categoryMapping.addChild(creationDate);
        XMLNode lastUpdateDate = CategoryMappingNodeBuilder.getSubNode("lastUpdateDate", xmlCategoryMapping.getLastUpdateDate());
        categoryMapping.addChild(lastUpdateDate);
        XMLProcessDefinitionsMapping processDefinitions = xmlCategoryMapping.getProcessDefinitions();
        if (processDefinitions != null) {
            XMLNode processDefinitionNode = CategoryMappingNodeBuilder.getProcessDefinitions(processDefinitions);
            categoryMapping.addChild(processDefinitionNode);
        }
        return categoryMapping;
    }

    public static XMLNode getRootNode() {
        return new XMLNode("categories");
    }

    private static XMLNode getSubNode(String name, String content) {
        XMLNode desc = new XMLNode(name);
        desc.setContent(content);
        return desc;
    }

    private static XMLNode getProcessDefinitions(XMLProcessDefinitionsMapping processDefinitions) {
        XMLNode processDefinitionsNode = new XMLNode("processDefinitions");
        for (String id : processDefinitions.getIds()) {
            XMLNode processDefinitionNode = new XMLNode("processDefinition");
            processDefinitionNode.setContent(id);
            processDefinitionsNode.addChild(processDefinitionNode);
        }
        return processDefinitionsNode;
    }
}

