/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.model.xml;

import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.xml.XMLProcessDefinitionsMapping;

public class XMLCategoryMapping
implements Comparable<XMLCategoryMapping> {
    public static final String CATEGORIES = "categories";
    public static final String CATEGORY = "category";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String CREATOR = "creator";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_UPDATE_DATE = "lastUpdateDate";
    public static final String PROCESS_DEFINITIONS = "processDefinitions";
    public static final String PROCESS_DEFINITION = "processDefinition";
    public static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    private String name;
    private String description;
    private String creator;
    private String creationDate;
    private String lastUpdateDate;
    private XMLProcessDefinitionsMapping processDefinitions;

    public XMLCategoryMapping(String name) {
        this.name = name;
        this.processDefinitions = new XMLProcessDefinitionsMapping();
    }

    public XMLCategoryMapping(String name, String description, String creator, String creationDate, String lastUpdateDate, XMLProcessDefinitionsMapping processDefinitions) {
        this.name = name;
        this.description = description;
        this.creator = creator;
        this.creationDate = creationDate;
        this.lastUpdateDate = lastUpdateDate;
        this.processDefinitions = processDefinitions;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public XMLProcessDefinitionsMapping getProcessDefinitions() {
        if (this.processDefinitions == null) {
            this.processDefinitions = new XMLProcessDefinitionsMapping();
        }
        return this.processDefinitions;
    }

    public void addProcessDefinition(String processDefinitionId) {
        if (this.processDefinitions == null) {
            this.processDefinitions = new XMLProcessDefinitionsMapping();
        }
        this.processDefinitions.addId(processDefinitionId);
    }

    public boolean deleteProcessDefinition(String processDefinitionId) {
        return this.processDefinitions.deleteId(processDefinitionId);
    }

    public void deleteAllProcessDefinition() {
        this.processDefinitions.deleteAll();
    }

    public void update(SCategory newCategory) {
        if (newCategory.getName() != null) {
            this.name = newCategory.getName();
        }
        if (newCategory.getDescription() != null) {
            this.description = newCategory.getDescription();
        }
        this.lastUpdateDate = String.valueOf(System.currentTimeMillis());
    }

    @Override
    public int compareTo(XMLCategoryMapping categoryMapping) {
        return this.name.compareTo(categoryMapping.getName());
    }
}

