/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.impl.SConnectorDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SNamedElementImpl;
import org.bonitasoft.engine.expression.model.SExpression;

public abstract class SFlowNodeDefinitionImpl
extends SNamedElementImpl
implements SFlowNodeDefinition {
    private static final long serialVersionUID = 7475429470423228259L;
    private final List<STransitionDefinition> incomings;
    private final List<STransitionDefinition> outgoings;
    private STransitionDefinition defaultTransition;
    private final List<SConnectorDefinition> connectors;
    private final Map<String, SConnectorDefinition> allConnectorsMap;
    private String description;
    private SExpression displayDescription;
    private SExpression displayDescriptionAfterCompletion;
    private SExpression displayName;
    private SFlowElementContainerDefinition parentContainer;
    private final Map<ConnectorEvent, List<SConnectorDefinition>> connectorsMap;

    public SFlowNodeDefinitionImpl(FlowNodeDefinition flowNodeDefinition, Map<String, STransitionDefinition> sTransitionsMap) {
        super(flowNodeDefinition.getName());
        this.incomings = this.buildIncomingTransitions(flowNodeDefinition, sTransitionsMap);
        this.outgoings = this.buildOutGoingTransitions(flowNodeDefinition, sTransitionsMap);
        if (flowNodeDefinition.getDefaultTransition() != null) {
            this.defaultTransition = sTransitionsMap.get(flowNodeDefinition.getDefaultTransition().getName());
        }
        List connectors2 = flowNodeDefinition.getConnectors();
        ArrayList<SConnectorDefinitionImpl> mConnectors = new ArrayList<SConnectorDefinitionImpl>(connectors2.size());
        this.connectorsMap = new HashMap<ConnectorEvent, List<SConnectorDefinition>>(2);
        this.connectorsMap.put(ConnectorEvent.ON_ENTER, new ArrayList());
        this.connectorsMap.put(ConnectorEvent.ON_FINISH, new ArrayList());
        for (ConnectorDefinition connector : connectors2) {
            SConnectorDefinitionImpl e = new SConnectorDefinitionImpl(connector);
            mConnectors.add(e);
            this.connectorsMap.get(e.getActivationEvent()).add(e);
        }
        this.connectors = Collections.unmodifiableList(mConnectors);
        this.allConnectorsMap = new HashMap<String, SConnectorDefinition>(2);
        this.description = flowNodeDefinition.getDescription();
        this.displayDescription = ServerModelConvertor.convertExpression(flowNodeDefinition.getDisplayDescription());
        this.displayDescriptionAfterCompletion = ServerModelConvertor.convertExpression(flowNodeDefinition.getDisplayDescriptionAfterCompletion());
        this.displayName = ServerModelConvertor.convertExpression(flowNodeDefinition.getDisplayName());
        this.setId(flowNodeDefinition.getId());
    }

    public SFlowNodeDefinitionImpl(long id, String name) {
        super(name);
        this.setId(id);
        this.incomings = new ArrayList<STransitionDefinition>();
        this.outgoings = new ArrayList<STransitionDefinition>();
        this.connectors = new ArrayList<SConnectorDefinition>();
        this.connectorsMap = new HashMap<ConnectorEvent, List<SConnectorDefinition>>(2);
        this.connectorsMap.put(ConnectorEvent.ON_ENTER, new ArrayList());
        this.connectorsMap.put(ConnectorEvent.ON_FINISH, new ArrayList());
        this.allConnectorsMap = new HashMap<String, SConnectorDefinition>(2);
    }

    @Override
    public SFlowElementContainerDefinition getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(SFlowElementContainerDefinition parentContainer) {
        this.parentContainer = parentContainer;
    }

    private List<STransitionDefinition> buildOutGoingTransitions(FlowNodeDefinition nodeDefinition, Map<String, STransitionDefinition> sTransitionsMap) {
        List outgoingTransitions = nodeDefinition.getOutgoingTransitions();
        ArrayList<STransitionDefinition> outgoings = new ArrayList<STransitionDefinition>();
        for (TransitionDefinition sTransition : outgoingTransitions) {
            STransitionDefinition outgoing = sTransitionsMap.get(sTransition.getName());
            outgoings.add(outgoing);
        }
        return outgoings;
    }

    private List<STransitionDefinition> buildIncomingTransitions(FlowNodeDefinition nodeDefinition, Map<String, STransitionDefinition> sTransitionsMap) {
        List incomingTransitions = nodeDefinition.getIncomingTransitions();
        ArrayList<STransitionDefinition> incomings = new ArrayList<STransitionDefinition>();
        for (TransitionDefinition sTransition : incomingTransitions) {
            STransitionDefinition incoming = sTransitionsMap.get(sTransition.getName());
            incomings.add(incoming);
        }
        return incomings;
    }

    @Override
    public List<STransitionDefinition> getOutgoingTransitions() {
        return Collections.unmodifiableList(this.outgoings);
    }

    @Override
    public List<STransitionDefinition> getIncomingTransitions() {
        return Collections.unmodifiableList(this.incomings);
    }

    @Override
    public List<SConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public boolean hasConnectors() {
        return this.connectors.size() > 0;
    }

    @Override
    public SConnectorDefinition getConnectorDefinition(String name) {
        return this.allConnectorsMap.get(name);
    }

    @Override
    public STransitionDefinition getDefaultTransition() {
        return this.defaultTransition;
    }

    public void setDefaultTransition(STransitionDefinition sTransition) {
        this.defaultTransition = sTransition;
    }

    @Override
    public boolean hasIncomingTransitions() {
        return !this.incomings.isEmpty();
    }

    @Override
    public boolean hasOutgoingTransitions() {
        return !this.outgoings.isEmpty();
    }

    @Override
    public List<SConnectorDefinition> getConnectors(ConnectorEvent connectorEvent) {
        return this.connectorsMap.get(connectorEvent);
    }

    public void addOutgoingTransition(STransitionDefinition sTransition) {
        if (!this.outgoings.contains(sTransition)) {
            this.outgoings.add(sTransition);
        }
    }

    public void addOutgoingTransition(int index, STransitionDefinition sTransition) {
        if (!this.outgoings.contains(sTransition)) {
            this.outgoings.add(index, sTransition);
        }
    }

    public void removeOutgoingTransition(STransitionDefinition sTransition) {
        this.outgoings.remove(sTransition);
    }

    public void addIncomingTransition(STransitionDefinition sTransition) {
        if (!this.incomings.contains(sTransition)) {
            this.incomings.add(sTransition);
        }
    }

    public void addIncomingTransition(int index, STransitionDefinition sTransition) {
        if (!this.incomings.contains(sTransition)) {
            this.incomings.add(index, sTransition);
        }
    }

    public void removeIncomingTransition(STransitionDefinition sTransition) {
        this.incomings.remove(sTransition);
    }

    public void addConnector(SConnectorDefinition sConnectorDefinition) {
        this.connectors.add(sConnectorDefinition);
        this.connectorsMap.get(sConnectorDefinition.getActivationEvent()).add(sConnectorDefinition);
        this.allConnectorsMap.put(sConnectorDefinition.getName(), sConnectorDefinition);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public SExpression getDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(SExpression displayDescription) {
        this.displayDescription = displayDescription;
    }

    @Override
    public SExpression getDisplayDescriptionAfterCompletion() {
        return this.displayDescriptionAfterCompletion;
    }

    public void setDisplayDescriptionAfterCompletion(SExpression displayDescriptionAfterCompletion) {
        this.displayDescriptionAfterCompletion = displayDescriptionAfterCompletion;
    }

    @Override
    public SExpression getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(SExpression displayName) {
        this.displayName = displayName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectors == null ? 0 : this.connectors.hashCode());
        result = 31 * result + (this.defaultTransition == null ? 0 : this.defaultTransition.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayDescription == null ? 0 : this.displayDescription.hashCode());
        result = 31 * result + (this.displayDescriptionAfterCompletion == null ? 0 : this.displayDescriptionAfterCompletion.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.incomings == null ? 0 : this.incomings.hashCode());
        result = 31 * result + (this.outgoings == null ? 0 : this.outgoings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SFlowNodeDefinitionImpl other = (SFlowNodeDefinitionImpl)obj;
        if (this.connectors == null ? other.connectors != null : !this.connectors.equals(other.connectors)) {
            return false;
        }
        if (this.defaultTransition == null ? other.defaultTransition != null : !this.defaultTransition.equals(other.defaultTransition)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayDescription == null ? other.displayDescription != null : !this.displayDescription.equals(other.displayDescription)) {
            return false;
        }
        if (this.displayDescriptionAfterCompletion == null ? other.displayDescriptionAfterCompletion != null : !this.displayDescriptionAfterCompletion.equals(other.displayDescriptionAfterCompletion)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.incomings == null ? other.incomings != null : !this.incomings.equals(other.incomings)) {
            return false;
        }
        return !(this.outgoings == null ? other.outgoings != null : !this.outgoings.equals(other.outgoings));
    }

    @Override
    public int getTransitionIndex(String transitionName) {
        int index = 1;
        boolean found = false;
        Iterator<STransitionDefinition> iterator = this.incomings.iterator();
        while (!found && iterator.hasNext()) {
            STransitionDefinition next = iterator.next();
            if (next.getName().equals(transitionName)) {
                found = true;
                continue;
            }
            ++index;
        }
        return index;
    }

    @Override
    public boolean isStartable() {
        return !this.hasIncomingTransitions();
    }

    @Override
    public boolean isParalleleOrInclusive() {
        return false;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public boolean isBoundaryEvent() {
        return SFlowNodeType.BOUNDARY_EVENT.equals((Object)this.getType());
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isEventSubProcess() {
        return false;
    }
}

