/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.IOException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public abstract class AbstractSetInFailedThread
extends Thread {
    private final TransactionExecutor txExecutor;
    private final long tenantId;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;
    private final PlatformServiceAccessor platformServiceAccessor;
    private final TenantServiceAccessor tenantServiceAccessor;
    private Throwable throwable;
    private boolean finished = false;

    public AbstractSetInFailedThread() throws STenantIdNotSetException, BonitaHomeNotSetException, BonitaHomeConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        ServiceAccessorFactory serviceAccessorFactory = ServiceAccessorFactory.getInstance();
        this.platformServiceAccessor = serviceAccessorFactory.createPlatformServiceAccessor();
        this.sessionAccessor = serviceAccessorFactory.createSessionAccessor();
        this.tenantId = this.sessionAccessor.getTenantId();
        this.tenantServiceAccessor = TenantServiceSingleton.getInstance(this.tenantId);
        this.txExecutor = this.tenantServiceAccessor.getTransactionExecutor();
        this.sessionService = this.platformServiceAccessor.getSessionService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SSession session = null;
        try {
            TransactionContentWithResult<SSession> transactionContent = new TransactionContentWithResult<SSession>(){
                private SSession session = null;

                @Override
                public void execute() throws SBonitaException {
                    this.session = AbstractSetInFailedThread.this.sessionService.createSession(AbstractSetInFailedThread.this.tenantId, AbstractSetInFailedThread.class.getSimpleName() + " with id " + AbstractSetInFailedThread.this.getId());
                    AbstractSetInFailedThread.this.sessionAccessor.setSessionInfo(this.session.getId(), AbstractSetInFailedThread.this.tenantId);
                    AbstractSetInFailedThread.this.setInFail();
                }

                @Override
                public SSession getResult() {
                    return this.session;
                }
            };
            this.txExecutor.execute(transactionContent);
            session = (SSession)transactionContent.getResult();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        finally {
            this.finished = true;
            if (session != null) {
                try {
                    this.sessionAccessor.deleteSessionId();
                    this.sessionService.deleteSession(session.getId());
                }
                catch (SSessionNotFoundException e) {}
            }
        }
    }

    protected abstract void setInFail() throws SBonitaException;

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public PlatformServiceAccessor getPlatformServiceAccessor() {
        return this.platformServiceAccessor;
    }

    public TenantServiceAccessor getTenantServiceAccessor() {
        return this.tenantServiceAccessor;
    }

    public SessionAccessor getSessionAccessor() {
        return this.sessionAccessor;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }
}

