/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class FailedStateSetter {
    private final FlowNodeExecutor flowNodeExecutor;
    private final ActivityInstanceService activityInstanceService;
    private final FlowNodeStateManager flowNodeStateManager;
    private final TechnicalLoggerService loggerService;

    public FailedStateSetter(FlowNodeExecutor flowNodeExecutor, ActivityInstanceService activityInstanceService, FlowNodeStateManager flowNodeStateManager, TechnicalLoggerService loggerService) {
        this.flowNodeExecutor = flowNodeExecutor;
        this.activityInstanceService = activityInstanceService;
        this.flowNodeStateManager = flowNodeStateManager;
        this.loggerService = loggerService;
    }

    public void setAsFailed(long flowNodeInstanceId) throws SFlowNodeReadException, SArchivingException, SFlowNodeModificationException {
        block2: {
            try {
                SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
                this.setAsFailed(flowNodeInstance);
            }
            catch (SFlowNodeNotFoundException e) {
                if (!this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) break block2;
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Impossible to put flow node instance in failed state: flow node instance with id '" + flowNodeInstanceId + "' not found.");
            }
        }
    }

    private void setAsFailed(SFlowNodeInstance flowNodeInstance) throws SArchivingException, SFlowNodeModificationException {
        long processDefinitionId = flowNodeInstance.getProcessDefinitionId();
        this.flowNodeExecutor.archiveFlowNodeInstance(flowNodeInstance, false, processDefinitionId);
        this.activityInstanceService.setState(flowNodeInstance, this.flowNodeStateManager.getFailedState());
    }
}

