/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.execution.work.WrappingBonitaWork;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.work.BonitaWork;

public class FailureHandlingBonitaWork
extends WrappingBonitaWork {
    private static final long serialVersionUID = 1L;

    public FailureHandlingBonitaWork(BonitaWork work) {
        super(work);
    }

    protected void logIncident(Exception cause, Exception exceptionWhenHandlingFailure) {
        Incident incident = new Incident(this.getDescription(), this.getRecoveryProcedure(), cause, exceptionWhenHandlingFailure);
        IncidentService incidentService = this.getTenantAccessor().getIncidentService();
        incidentService.report(this.getTenantId(), incident);
    }

    TenantServiceAccessor getTenantAccessor() {
        try {
            return TenantServiceSingleton.getInstance(this.getTenantId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Map<String, Object> context) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        SessionAccessor sessionAccessor = tenantAccessor.getSessionAccessor();
        context.put("tenantAccessor", tenantAccessor);
        try {
            sessionAccessor.setTenantId(this.getTenantId());
            if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                loggerService.log(this.getClass(), TechnicalLogSeverity.TRACE, "Starting work: " + this.getDescription());
            }
            this.getWrappedWork().work(context);
        }
        catch (SExpressionEvaluationException e) {
            this.handleFailureWrappedWork(loggerService, e, context);
        }
        catch (Exception e) {
            this.handleFailure(e, context);
        }
        finally {
            sessionAccessor.deleteTenantId();
        }
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "The work [" + this.getDescription() + "] failed. The failure will be handled.");
        }
        this.handleFailureWrappedWork(loggerService, e, context);
    }

    private void logException(TechnicalLoggerService loggerService, Throwable e) {
        if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            StringBuilder logBuilder = new StringBuilder(e.getClass().getName());
            logBuilder.append(" : \"");
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                logBuilder.append("No message");
            } else {
                logBuilder.append(message);
            }
            logBuilder.append("\"");
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, logBuilder.toString(), e);
        }
    }

    private void handleFailureWrappedWork(TechnicalLoggerService loggerService, Exception e, Map<String, Object> context) {
        try {
            this.getWrappedWork().handleFailure(e, context);
            this.logException(loggerService, e);
        }
        catch (Exception e1) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unexpected error while executing work [" + this.getDescription() + "]" + ". You may consider restarting the system. This will restart all works.", e);
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to handle the failure. ", e1);
            this.logIncident(e, e1);
        }
    }
}

