/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.api.impl.DocumentHelper;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.ModelConvertor;

public class DocumentListReferenceExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private final DocumentService documentService;
    private final ActivityInstanceService activityInstanceService;
    private final DocumentHelper documentHelper;

    public DocumentListReferenceExpressionExecutorStrategy(DocumentService documentService, ActivityInstanceService flowNodeInstanceService, ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService) {
        this.documentService = documentService;
        this.activityInstanceService = flowNodeInstanceService;
        this.documentHelper = new DocumentHelper(documentService, processDefinitionService, processInstanceService);
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        return this.evaluate(Collections.singletonList(expression), context, resolvedExpressions, containerState).get(0);
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_DOCUMENT_LIST;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        Long containerId = (Long)context.get("containerId");
        String containerType = (String)context.get("containerType");
        try {
            Long time = (Long)context.get("time");
            long processInstanceId = this.getProcessInstance(containerId, containerType, time != null);
            ArrayList<Object> results = new ArrayList<Object>(expressions.size());
            for (SExpression expression : expressions) {
                results.add(this.getDocumentList(processInstanceId, expression.getContent(), time));
            }
            return results;
        }
        catch (SExpressionDependencyMissingException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SExpressionEvaluationException((Throwable)e, null);
        }
    }

    List<Document> getDocumentList(long processInstanceId, String name, Long time) throws SBonitaReadException {
        List<SMappedDocument> documentList = this.getAllDocumentOfTheList(processInstanceId, name, time);
        try {
            if (documentList.isEmpty() && !this.documentHelper.isListDefinedInDefinition(name, processInstanceId)) {
                return null;
            }
        }
        catch (SObjectNotFoundException e) {
            return null;
        }
        return ModelConvertor.toDocuments(documentList, this.documentService);
    }

    private List<SMappedDocument> getAllDocumentOfTheList(long processInstanceId, String name, Long time) throws SBonitaReadException {
        List<SMappedDocument> mappedDocuments;
        if (time != null) {
            return this.documentService.getDocumentList(name, processInstanceId, time);
        }
        QueryOptions queryOptions = new QueryOptions(0, 100);
        ArrayList<SMappedDocument> result = new ArrayList<SMappedDocument>();
        do {
            mappedDocuments = this.documentService.getDocumentList(name, processInstanceId, queryOptions.getFromIndex(), queryOptions.getNumberOfResults());
            result.addAll(mappedDocuments);
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (mappedDocuments.size() == 100);
        return result;
    }

    private long getProcessInstance(Long containerId, String containerType, boolean flowNodeIsArchived) throws SBonitaException {
        if (containerId == null || containerType == null) {
            throw new SExpressionDependencyMissingException("The context to retrieve the document is not set.");
        }
        if (DataInstanceContainer.PROCESS_INSTANCE.name().equals(containerType)) {
            return containerId;
        }
        if (flowNodeIsArchived) {
            return this.activityInstanceService.getMostRecentArchivedActivityInstance(containerId).getParentProcessInstanceId();
        }
        return this.activityInstanceService.getFlowNodeInstance(containerId).getParentProcessInstanceId();
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

