/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.ExportedCustomUserInfoValue;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.ExportedUserBuilder;
import org.bonitasoft.engine.identity.ExportedUserBuilderFactory;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoValueBuilderFactory;
import org.bonitasoft.engine.identity.xml.Organization;
import org.bonitasoft.engine.identity.xml.OrganizationNodeBuilder;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.xml.XMLNode;
import org.bonitasoft.engine.xml.XMLWriter;

public class ExportOrganization
implements TransactionContentWithResult<String> {
    private final XMLWriter xmlWriter;
    private final IdentityService identityService;
    private Map<Long, String> userNames;
    private String xmlOrganization;
    private final int maxResults;

    public ExportOrganization(XMLWriter xmlWriter, IdentityService identityService, int maxResults) {
        this.xmlWriter = xmlWriter;
        this.identityService = identityService;
        this.maxResults = maxResults;
    }

    @Override
    public void execute() throws SBonitaException {
        this.userNames = new HashMap<Long, String>(20);
        List<SCustomUserInfoDefinition> customUserInfoDefinitions = this.getAllCustomUserInfoDefinitions();
        List<ExportedUser> users = this.getAllUsers(ExportOrganization.getUserInfoDefinitionNames(customUserInfoDefinitions));
        List<Role> roles = this.getAllRoles();
        List<SGroup> groups = this.getAllGroups();
        HashMap<Long, String> groupIdParentPath = new HashMap<Long, String>(groups.size());
        for (SGroup group : groups) {
            groupIdParentPath.put(group.getId(), group.getParentPath());
        }
        List<SUserMembership> userMemberships = this.getAllUserMemberships();
        List<Group> clientGroups = ModelConvertor.toGroups(groups);
        List<UserMembership> clientUserMemberships = ModelConvertor.toUserMembership(userMemberships, this.userNames, groupIdParentPath);
        Organization organization = new Organization(users, roles, clientGroups, clientUserMemberships, customUserInfoDefinitions);
        this.buildXmlContent(organization, groupIdParentPath);
    }

    private static Map<Long, String> getUserInfoDefinitionNames(List<SCustomUserInfoDefinition> userInfoDefinitions) {
        HashMap<Long, String> names = new HashMap<Long, String>(userInfoDefinitions.size());
        for (SCustomUserInfoDefinition userInfoDefinition : userInfoDefinitions) {
            names.put(userInfoDefinition.getId(), userInfoDefinition.getName());
        }
        return names;
    }

    private void buildXmlContent(Organization organization, Map<Long, String> groupIdParentPath) throws SIdentityException {
        XMLNode document = OrganizationNodeBuilder.getDocument(organization, this.userNames, groupIdParentPath);
        StringWriter writer = new StringWriter();
        try {
            this.xmlWriter.write(document, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new SIdentityException(e);
        }
        this.xmlOrganization = writer.toString();
    }

    @Override
    public String getResult() {
        return this.xmlOrganization;
    }

    protected List<SCustomUserInfoDefinition> getAllCustomUserInfoDefinitions() throws SIdentityException {
        ArrayList<SCustomUserInfoDefinition> allCustomUserInfoDefinitions = new ArrayList<SCustomUserInfoDefinition>(5);
        List<SCustomUserInfoDefinition> currentPage = null;
        int startIndex = 0;
        do {
            currentPage = this.identityService.getCustomUserInfoDefinitions(startIndex, this.maxResults);
            allCustomUserInfoDefinitions.addAll(currentPage);
            startIndex += this.maxResults;
        } while (currentPage.size() == this.maxResults);
        return allCustomUserInfoDefinitions;
    }

    private List<SUserMembership> getAllUserMemberships() throws SIdentityException {
        long numberOfUserMemberships = this.identityService.getNumberOfUserMemberships();
        ArrayList<SUserMembership> sUserMemberships = new ArrayList<SUserMembership>();
        int startIndex = 0;
        while ((long)startIndex < numberOfUserMemberships) {
            sUserMemberships.addAll(this.identityService.getUserMemberships(startIndex, this.maxResults));
            startIndex += this.maxResults;
        }
        return sUserMemberships;
    }

    private List<SGroup> getAllGroups() throws SIdentityException {
        long groupNumber = this.identityService.getNumberOfGroups();
        ArrayList<SGroup> groups = new ArrayList<SGroup>(this.getInitialListCapacity(groupNumber));
        int startIndex = 0;
        while ((long)startIndex < groupNumber) {
            groups.addAll(this.identityService.getGroups(startIndex, this.maxResults));
            startIndex += this.maxResults;
        }
        return groups;
    }

    private List<Role> getAllRoles() throws SIdentityException {
        long roleNumber = this.identityService.getNumberOfRoles();
        ArrayList<Role> roles = new ArrayList<Role>(this.getInitialListCapacity(roleNumber));
        int startIndex = 0;
        while ((long)startIndex < roleNumber) {
            List<SRole> sRoles = this.identityService.getRoles(startIndex, this.maxResults);
            roles.addAll(ModelConvertor.toRoles(sRoles));
            startIndex += this.maxResults;
        }
        return roles;
    }

    private List<ExportedUser> getAllUsers(Map<Long, String> userInfoDefinitionNames) throws SBonitaException {
        long userNumber = this.identityService.getNumberOfUsers();
        ArrayList<ExportedUser> users = new ArrayList<ExportedUser>(this.getInitialListCapacity(userNumber));
        int startIndex = 0;
        while ((long)startIndex <= userNumber) {
            users.addAll(this.getNextUsersPage(startIndex, this.maxResults, userInfoDefinitionNames));
            startIndex += this.maxResults;
        }
        return users;
    }

    private int getInitialListCapacity(long elementsToRetrive) {
        return Integer.MAX_VALUE >= elementsToRetrive ? Long.valueOf(elementsToRetrive).intValue() : Integer.MAX_VALUE;
    }

    private List<ExportedUser> getNextUsersPage(int startIndex, int numberPerPage, Map<Long, String> userInfoDefinitionNames) throws SBonitaException {
        ArrayList<ExportedUser> currentUsersPage = new ArrayList<ExportedUser>(numberPerPage);
        List<SUser> sUsers = this.identityService.getUsers(startIndex, numberPerPage);
        for (SUser sUser : sUsers) {
            this.userNames.put(sUser.getId(), sUser.getUserName());
            currentUsersPage.add(this.toExportedUser(sUser, userInfoDefinitionNames));
        }
        return currentUsersPage;
    }

    protected ExportedUser toExportedUser(SUser sUser, Map<Long, String> userInfoDefinitionNames) throws SBonitaException {
        String managerUserName = this.getManagerUsername(sUser);
        ExportedUserBuilder clientUserbuilder = ExportedUserBuilderFactory.createNewInstance(sUser.getUserName(), sUser.getPassword());
        clientUserbuilder.setPasswordEncrypted(true);
        clientUserbuilder.setFirstName(sUser.getFirstName());
        clientUserbuilder.setLastName(sUser.getLastName());
        clientUserbuilder.setTitle(sUser.getTitle());
        clientUserbuilder.setJobTitle(sUser.getJobTitle());
        clientUserbuilder.setCreatedBy(sUser.getCreatedBy());
        clientUserbuilder.setIconName(sUser.getIconName());
        clientUserbuilder.setIconPath(sUser.getIconPath());
        clientUserbuilder.setEnabled(sUser.isEnabled());
        this.setManagerInfo(managerUserName, clientUserbuilder, sUser.getManagerUserId());
        this.setPersonalContactInfo(sUser, clientUserbuilder);
        this.setProfessionalContactInfo(sUser, clientUserbuilder);
        this.addCustomUserInfoValues(sUser.getId(), clientUserbuilder, userInfoDefinitionNames);
        return clientUserbuilder.done();
    }

    protected void addCustomUserInfoValues(long userId, ExportedUserBuilder clientUserbuilder, Map<Long, String> userInfoDefinitionNames) throws SBonitaReadException {
        List<SCustomUserInfoValue> userInfoValues = this.getAllCustomUserInfoForUser(userId);
        for (SCustomUserInfoValue infoValue : userInfoValues) {
            String definitionName = userInfoDefinitionNames.get(infoValue.getDefinitionId());
            clientUserbuilder.addCustomUserInfoValue(new ExportedCustomUserInfoValue(definitionName, infoValue.getValue()));
        }
    }

    protected List<SCustomUserInfoValue> getAllCustomUserInfoForUser(long userId) throws SBonitaReadException {
        List<SCustomUserInfoValue> currentPage;
        ArrayList<SCustomUserInfoValue> allValues = new ArrayList<SCustomUserInfoValue>(5);
        int fromIndex = 0;
        do {
            QueryOptions options = this.getQueryOptions(userId, fromIndex);
            currentPage = this.identityService.searchCustomUserInfoValue(options);
            allValues.addAll(currentPage);
            fromIndex += this.maxResults;
        } while (currentPage.size() == this.maxResults);
        return allValues;
    }

    private QueryOptions getQueryOptions(long userId, int fromIndex) {
        SCustomUserInfoValueBuilderFactory keyProvider = BuilderFactory.get(SCustomUserInfoValueBuilderFactory.class);
        OrderByOption orderByOption = new OrderByOption(SCustomUserInfoValue.class, keyProvider.getIdKey(), OrderByType.ASC);
        FilterOption filterOption = new FilterOption(SCustomUserInfoValue.class, keyProvider.getUserIdKey(), userId);
        return new QueryOptions(fromIndex, this.maxResults, Collections.singletonList(orderByOption), Collections.singletonList(filterOption), null);
    }

    private void setPersonalContactInfo(SUser sUser, ExportedUserBuilder clientUserbuilder) throws SIdentityException {
        SContactInfo persoInfo = this.identityService.getUserContactInfo(sUser.getId(), true);
        if (persoInfo != null) {
            clientUserbuilder.setPersonalData(ModelConvertor.toUserContactData(persoInfo));
        }
    }

    private void setProfessionalContactInfo(SUser sUser, ExportedUserBuilder clientUserbuilder) throws SIdentityException {
        SContactInfo proInfo = this.identityService.getUserContactInfo(sUser.getId(), false);
        if (proInfo != null) {
            clientUserbuilder.setProfessionalData(ModelConvertor.toUserContactData(proInfo));
        }
    }

    private void setManagerInfo(String managerUserName, ExportedUserBuilder clientUserbuilder, long managerUserId) {
        clientUserbuilder.setManagerUserId(managerUserId);
        clientUserbuilder.setManagerUserName(managerUserName);
    }

    private String getManagerUsername(SUser sUser) throws SUserNotFoundException {
        long managerUserId = sUser.getManagerUserId();
        String managerUserName = null;
        if (managerUserId > 0L && (managerUserName = this.userNames.get(managerUserId)) == null) {
            SUser manager = this.identityService.getUser(sUser.getManagerUserId());
            this.userNames.put(manager.getId(), manager.getUserName());
            managerUserName = manager.getUserName();
        }
        return managerUserName;
    }
}

