/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.search.FilterOperationType;

public class FilterOption
implements Serializable {
    private static final long serialVersionUID = -5043588187864921664L;
    private Class<? extends PersistentObject> persistentClass;
    private String fieldName;
    private Object value;
    private Object to;
    private Object from;
    private Collection<?> in;
    private FilterOperationType operationType;

    public FilterOption(Class<? extends PersistentObject> persistentClass, String fieldName, Object value, FilterOperationType operatorType) {
        this(persistentClass, fieldName);
        this.value = value;
        this.operationType = operatorType;
    }

    public FilterOption(Class<? extends PersistentObject> persistentClass, String fieldName, Object value) {
        this(persistentClass, fieldName, value, FilterOperationType.EQUALS);
    }

    public FilterOption(Class<? extends PersistentObject> persistentClass, String fieldName) {
        this.persistentClass = persistentClass;
        this.fieldName = fieldName;
    }

    public FilterOption(Class<? extends PersistentObject> persistentClass, String fieldName, Object from, Object to) {
        this(persistentClass, fieldName, null, FilterOperationType.BETWEEN);
        this.from = from;
        this.to = to;
    }

    public FilterOption(FilterOperationType operatorType) {
        this.operationType = operatorType;
    }

    public Class<? extends PersistentObject> getPersistentClass() {
        return this.persistentClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getFrom() {
        return this.from;
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public Collection<?> getIn() {
        return this.in;
    }

    public void setIn(Collection<?> in) {
        this.in = in;
    }

    public void setFilterOperationType(FilterOperationType operatorType) {
        this.operationType = operatorType;
    }

    public Object getTo() {
        return this.to;
    }

    public FilterOption equalsTo(Object value) {
        this.value = value;
        this.operationType = FilterOperationType.EQUALS;
        return this;
    }

    public FilterOption like(Object value) {
        this.value = value;
        this.operationType = FilterOperationType.LIKE;
        return this;
    }

    public FilterOption between(Object from, Object to) {
        this.from = from;
        this.to = to;
        this.operationType = FilterOperationType.BETWEEN;
        return this;
    }

    public FilterOption greaterThan(Object value) {
        this.from = value;
        this.operationType = FilterOperationType.GREATER;
        return this;
    }

    public FilterOption lessThan(Object value) {
        this.to = value;
        this.operationType = FilterOperationType.LESS;
        return this;
    }

    public FilterOption greaterThanOrEquals(Object value) {
        this.from = value;
        this.operationType = FilterOperationType.GREATER_OR_EQUALS;
        return this;
    }

    public FilterOption lessThanOrEquals(Object value) {
        this.to = value;
        this.operationType = FilterOperationType.LESS_OR_EQUALS;
        return this;
    }

    public FilterOption in(Collection<?> values) {
        this.in = values;
        this.operationType = FilterOperationType.IN;
        return this;
    }

    public FilterOption in(Object ... value) {
        this.in = Arrays.asList(value);
        this.operationType = FilterOperationType.IN;
        return this;
    }

    public FilterOperationType getFilterOperationType() {
        return this.operationType;
    }

    public static FilterOption leftParenthesis() {
        return new FilterOption(FilterOperationType.L_PARENTHESIS);
    }

    public static FilterOption rightParenthesis() {
        return new FilterOption(FilterOperationType.R_PARENTHESIS);
    }

    public static FilterOption or() {
        return new FilterOption(FilterOperationType.OR);
    }

    public static FilterOption and() {
        return new FilterOption(FilterOperationType.AND);
    }

    public Collection<?> getValues() {
        return this.in;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterOption)) {
            return false;
        }
        FilterOption that = (FilterOption)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.in != null ? !this.in.equals(that.in) : that.in != null) {
            return false;
        }
        if (this.operationType != that.operationType) {
            return false;
        }
        if (this.persistentClass != null ? !this.persistentClass.equals(that.persistentClass) : that.persistentClass != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.persistentClass != null ? this.persistentClass.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.in != null ? this.in.hashCode() : 0);
        result = 31 * result + (this.operationType != null ? this.operationType.hashCode() : 0);
        return result;
    }
}

