/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.command.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.platform.command.PlatformCommandService;
import org.bonitasoft.engine.platform.command.SPlatformCommandAlreadyExistsException;
import org.bonitasoft.engine.platform.command.SPlatformCommandCreationException;
import org.bonitasoft.engine.platform.command.SPlatformCommandDeletionException;
import org.bonitasoft.engine.platform.command.SPlatformCommandGettingException;
import org.bonitasoft.engine.platform.command.SPlatformCommandNotFoundException;
import org.bonitasoft.engine.platform.command.SPlatformCommandUpdateException;
import org.bonitasoft.engine.platform.command.model.SPlatformCommand;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.UpdateDescriptor;

public class PlatformCommandServiceImpl
implements PlatformCommandService {
    private final PersistenceService platformPersistenceService;
    private final TechnicalLoggerService logger;

    public PlatformCommandServiceImpl(PersistenceService platformPersistenceService, TechnicalLoggerService logger) {
        this.platformPersistenceService = platformPersistenceService;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(SPlatformCommand platformCommand) throws SPlatformCommandAlreadyExistsException, SPlatformCommandCreationException, SPlatformCommandGettingException {
        block11: {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "create"));
            }
            NullCheckingUtil.checkArgsNotNull(platformCommand);
            SPlatformCommand existedPlatformCommand = null;
            try {
                existedPlatformCommand = this.getPlatformCommand(platformCommand.getName());
            }
            catch (SPlatformCommandNotFoundException e1) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "create", e1));
                }
            }
            finally {
                if (existedPlatformCommand == null) break block11;
                throw new SPlatformCommandAlreadyExistsException("platformCommand already existed");
            }
        }
        try {
            this.platformPersistenceService.insert(platformCommand);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "create"));
            }
        }
        catch (SPersistenceException pe) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "create", pe));
            }
            throw new SPlatformCommandCreationException(pe);
        }
    }

    public void deletePlatformCommand(SPlatformCommand sPlatformCommand) throws SPlatformCommandDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deletePlatformCommand"));
        }
        try {
            this.platformPersistenceService.delete(sPlatformCommand);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deletePlatformCommand"));
            }
        }
        catch (SPersistenceException pe) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deletePlatformCommand", pe));
            }
            throw new SPlatformCommandDeletionException(pe);
        }
    }

    @Override
    public void delete(String platformCommandName) throws SPlatformCommandNotFoundException, SPlatformCommandDeletionException, SPlatformCommandGettingException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "delete"));
        }
        SPlatformCommand sPlatformCommand = this.getPlatformCommand(platformCommandName);
        this.deletePlatformCommand(sPlatformCommand);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "delete"));
        }
    }

    @Override
    public void deleteAll() throws SPlatformCommandDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteAll"));
        }
        QueryOptions queryOptions = new QueryOptions(0, 100, SPlatformCommand.class, "id", OrderByType.ASC);
        List<SPlatformCommand> sPlatformCommands = null;
        do {
            try {
                sPlatformCommands = this.getPlatformCommands(queryOptions);
            }
            catch (SPlatformCommandGettingException e) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteAll", e));
                }
                throw new SPlatformCommandDeletionException(e);
            }
            for (SPlatformCommand sPlatformCommand : sPlatformCommands) {
                this.deletePlatformCommand(sPlatformCommand);
            }
        } while (sPlatformCommands.size() == queryOptions.getNumberOfResults());
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteAll"));
        }
    }

    @Override
    public List<SPlatformCommand> getPlatformCommands(QueryOptions queryOptions) throws SPlatformCommandGettingException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getPlatformCommands"));
        }
        Map<String, Object> parameters = Collections.emptyMap();
        try {
            List<SPlatformCommand> sPlatformCommands = this.platformPersistenceService.selectList(new SelectListDescriptor("getPlatformCommands", parameters, SPlatformCommand.class, queryOptions));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getPlatformCommands"));
            }
            return sPlatformCommands;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getPlatformCommands", bre));
            }
            throw new SPlatformCommandGettingException(bre);
        }
    }

    @Override
    public SPlatformCommand getPlatformCommand(String platformCommandName) throws SPlatformCommandNotFoundException, SPlatformCommandGettingException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getPlatformCommand"));
        }
        Map<String, Object> parameters = Collections.singletonMap("name", platformCommandName);
        try {
            SPlatformCommand sPlatformCommand = (SPlatformCommand)this.platformPersistenceService.selectOne(new SelectOneDescriptor("getPlatformCommandByName", parameters, SPlatformCommand.class));
            if (sPlatformCommand == null) {
                throw new SPlatformCommandNotFoundException("No platformCommand exists using name: " + platformCommandName);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getPlatformCommand"));
            }
            return sPlatformCommand;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getPlatformCommand", bre));
            }
            throw new SPlatformCommandGettingException(bre);
        }
    }

    @Override
    public void update(SPlatformCommand platformCommand, EntityUpdateDescriptor updateDescriptor) throws SPlatformCommandUpdateException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "update"));
        }
        UpdateDescriptor desc = new UpdateDescriptor(platformCommand);
        desc.addFields(updateDescriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "update"));
            }
        }
        catch (SPersistenceException pe) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "update", pe));
            }
            throw new SPlatformCommandUpdateException(pe);
        }
    }
}

