/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile.persistence;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class SelectDescriptorBuilder {
    private static final String ROLE_ID = "roleId";
    private static final String GROUP_ID = "groupId";
    private static final String USER_ID = "userId";
    private static final String PROFILE_ID = "profileId";
    private static final String PARENT_ID = "parentId";

    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static SelectOneDescriptor<Long> getNumberOfElement(String elementName, Class<? extends PersistentObject> clazz) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOf" + elementName, parameters, clazz, Long.class);
    }

    public static <T extends PersistentObject> SelectOneDescriptor<T> getElementByNameDescriptor(Class<T> clazz, String elementName, String name) {
        Map<String, Object> parameters = Collections.singletonMap("name", name);
        return new SelectOneDescriptor("get" + elementName + "ByName", parameters, clazz);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, clazz, field, order);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor("get" + elementName + "s", parameters, clazz, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfEntriesOfProfile(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("getNumberOfEntriesOfProfile", parameters, SProfileEntry.class);
    }

    public static SelectListDescriptor<SProfileEntry> getEntriesOfProfile(long profileId, String field, OrderByType order, int fromIndex, int numberOfProfileEntries) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProfileEntries, SProfileEntry.class, field, order);
        return SelectDescriptorBuilder.getEntriesOfProfile(profileId, queryOptions);
    }

    public static SelectListDescriptor<SProfileEntry> getEntriesOfProfile(long profileId, int fromIndex, int numberOfProfileEntries) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProfileEntries);
        return SelectDescriptorBuilder.getEntriesOfProfile(profileId, queryOptions);
    }

    public static SelectListDescriptor<SProfileEntry> getEntriesOfProfile(long profileId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectListDescriptor<SProfileEntry>("getEntriesOfProfile", parameters, SProfileEntry.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileEntry> getEntriesOfProfile(long profileId, long parentId, String field, OrderByType order, int fromIndex, int numberOfProfileEntries) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProfileEntries, SProfileEntry.class, field, order);
        return SelectDescriptorBuilder.getEntriesOfProfile(profileId, parentId, queryOptions);
    }

    public static SelectListDescriptor<SProfileEntry> getEntriesOfProfile(long profileId, long parentId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put(PROFILE_ID, profileId);
        parameters.put(PARENT_ID, parentId);
        return new SelectListDescriptor<SProfileEntry>("getEntriesOfProfileByParentId", parameters, SProfileEntry.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileMember> serarchSProfileMembersForUser(long profileId, int fromIndex, int numberOfUserProfiles, List<OrderByOption> orderByOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUserProfiles, orderByOptions);
        return new SelectListDescriptor<SProfileMember>("searchSProfileMembersForUser", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfSProfileMembersForUser(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("countSProfileMembersForUser", parameters, SProfileMember.class);
    }

    public static SelectListDescriptor<SProfileMember> getSProfileMembersForGroup(long profileId, int fromIndex, int numberOfUserProfiles, List<OrderByOption> orderByOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUserProfiles, orderByOptions);
        return new SelectListDescriptor<SProfileMember>("searchSProfileMembersForGroup", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfSProfileMembersForGroup(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("countSProfileMembersForGroup", parameters, SProfileMember.class);
    }

    public static SelectListDescriptor<SProfileMember> getSProfileMembersForRole(long profileId, int fromIndex, int numberOfUserProfiles, List<OrderByOption> orderByOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUserProfiles, orderByOptions);
        return new SelectListDescriptor<SProfileMember>("searchSProfileMembersForRole", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfSProfileMembersForRole(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("countSProfileMembersForRole", parameters, SProfileMember.class);
    }

    public static SelectListDescriptor<SProfileMember> getSProfileMembersForRoleAndGroup(long profileId, int fromIndex, int numberOfUserProfiles, List<OrderByOption> orderByOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUserProfiles, orderByOptions);
        return new SelectListDescriptor<SProfileMember>("searchSProfileMembersForRoleAndGroup", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfSProfileMembersForRoleAndGroup(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("countSProfileMembersForRoleAndGroup", parameters, SProfileMember.class);
    }

    public static SelectListDescriptor<SProfileMember> getDirectProfileMembersOfUser(long userId, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SProfileMember.class, field, order);
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(USER_ID, userId);
        return new SelectListDescriptor<SProfileMember>("getDirectProfileMembersOfUser", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileMember> getDirectProfileMembersOfGroup(long groupId, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SProfileMember.class, field, order);
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(GROUP_ID, groupId);
        return new SelectListDescriptor<SProfileMember>("getDirectProfileMembersOfGroup", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileMember> getDirectProfileMembersOfRole(long roleId, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SProfileMember.class, field, order);
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(ROLE_ID, roleId);
        return new SelectListDescriptor<SProfileMember>("getDirectProfileMembersOfRole", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileMember> getProfileMembers(int fromIndex, int numberOfElements, String field, OrderByType order) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SProfileMember.class, field, order);
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        return new SelectListDescriptor<SProfileMember>("getProfileMembers", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectListDescriptor<SProfile> getProfilesOfUser(long userId, int fromIndex, int numberOfElements, String field, OrderByType order) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SProfile.class, field, order);
        Map<String, Object> parameters = Collections.singletonMap(USER_ID, userId);
        return new SelectListDescriptor<SProfile>("getProfilesOfUser", parameters, SProfile.class, queryOptions);
    }

    public static SelectListDescriptor<SProfileMember> getSProfileMembersWithoutDisplayName(long profileId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectListDescriptor<SProfileMember>("getSProfileMembersWithoutDisplayName", parameters, SProfileMember.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfUsersOfProfile(long profileId) {
        Map<String, Object> parameters = Collections.singletonMap(PROFILE_ID, profileId);
        return new SelectOneDescriptor<Long>("getNumberOfProfileMembersOfProfile", parameters, SProfileMember.class);
    }

    public static SelectByIdDescriptor<SProfileMember> getProfileMemberWithoutDisplayName(long profileMemberId) {
        return new SelectByIdDescriptor<SProfileMember>("getProfileMemberWithoutDisplayNameById", SProfileMember.class, profileMemberId);
    }
}

