/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.document;

import java.util.List;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.model.archive.SAMappedDocument;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.AbstractArchivedDocumentSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchArchivedDocumentDescriptor;

public class SearchArchivedDocuments
extends AbstractArchivedDocumentSearchEntity {
    private final DocumentService documentService;

    public SearchArchivedDocuments(DocumentService documentService, SearchArchivedDocumentDescriptor searchDescriptor, SearchOptions options) {
        super(searchDescriptor, options, documentService);
        this.documentService = documentService;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaReadException {
        return this.documentService.getNumberOfArchivedDocuments(searchOptions);
    }

    @Override
    public List<SAMappedDocument> executeSearch(QueryOptions searchOptions) throws SBonitaReadException {
        return this.documentService.searchArchivedDocuments(searchOptions);
    }
}

