/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services.impl;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogBuilderFactory;
import org.bonitasoft.engine.services.QueriableLogSessionProvider;

public class QueriableLogUpdater {
    private static final int MAX_MESSAGE_LENGTH = 255;
    private final QueriableLogSessionProvider sessionProvider;
    private final PlatformService platformService;
    private final TechnicalLoggerService logger;

    public QueriableLogUpdater(QueriableLogSessionProvider sessionProvider, PlatformService platformService, TechnicalLoggerService logger) {
        this.sessionProvider = sessionProvider;
        this.platformService = platformService;
        this.logger = logger;
    }

    public SQueriableLog buildFinalLog(String callerClassName, String callerMethodName, SQueriableLog log) {
        SQueriableLogBuilderFactory fact = BuilderFactory.get(SQueriableLogBuilderFactory.class);
        SQueriableLogBuilder builder = fact.fromInstance(log);
        String rawMessage = log.getRawMessage();
        if (rawMessage.length() > 255) {
            String truncatedMessage = rawMessage.substring(0, 255);
            builder.rawMessage(truncatedMessage);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                StringBuilder stb = new StringBuilder();
                stb.append("The queriable log message is too long and will be truncated to ");
                stb.append(255);
                stb.append(" characters. The original message is '");
                stb.append(rawMessage);
                stb.append("'. It will be truncated to '");
                stb.append(truncatedMessage);
                stb.append("'");
                this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, stb.toString());
            }
        }
        SQueriableLog finalLog = builder.callerClassName(callerClassName).callerMethodName(callerMethodName).userId(this.sessionProvider.getUserId()).clusterNode(this.sessionProvider.getClusterNode()).productVersion(this.platformService.getSPlatformProperties().getPlatformVersion()).done();
        return finalLog;
    }
}

