/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.flownode;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.QueryOptions;

public class SearchFlowNodeInstances<T extends SFlowNodeInstance>
implements TransactionContentWithResult<List<T>> {
    private final FlowNodeInstanceService flowNodeInstanceService;
    private final QueryOptions queryOptions;
    private final Class<T> entityClass;
    private List<T> result;
    private long count;

    public SearchFlowNodeInstances(FlowNodeInstanceService flowNodeInstanceService, QueryOptions queryOptions, Class<T> entityClass) {
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.queryOptions = queryOptions;
        this.entityClass = entityClass;
    }

    @Override
    public void execute() throws SBonitaException {
        this.result = this.flowNodeInstanceService.searchFlowNodeInstances(this.entityClass, this.queryOptions);
        QueryOptions countOptions = new QueryOptions(0, 1, Collections.<OrderByOption>emptyList(), this.queryOptions.getFilters(), this.queryOptions.getMultipleFilter());
        this.count = this.flowNodeInstanceService.getNumberOfFlowNodeInstances(this.entityClass, countOptions);
    }

    @Override
    public List<T> getResult() {
        return this.result;
    }

    public long getCount() {
        return this.count;
    }
}

