/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.events.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.events.impl.AbstractEventServiceImpl;
import org.bonitasoft.engine.events.model.HandlerRegistrationException;
import org.bonitasoft.engine.events.model.HandlerUnregistrationException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class EventServiceImpl
extends AbstractEventServiceImpl {
    protected Map<String, List<SHandler<SEvent>>> registeredHandlers = new HashMap<String, List<SHandler<SEvent>>>();

    public EventServiceImpl(TechnicalLoggerService logger) {
        super(logger);
    }

    @Override
    protected boolean containsHandlerFor(String key) {
        return this.registeredHandlers.containsKey(key);
    }

    @Override
    protected Collection<SHandler<SEvent>> getHandlersFor(String eventType) {
        return this.registeredHandlers.get(eventType);
    }

    @Override
    protected void addHandlerFor(String eventType, SHandler<SEvent> handler) throws HandlerRegistrationException {
        if (this.containsHandlerFor(eventType)) {
            List<SHandler<SEvent>> handlers = this.registeredHandlers.get(eventType);
            for (SHandler<SEvent> tmpHandler : handlers) {
                if (!tmpHandler.getIdentifier().equals(handler.getIdentifier())) continue;
                throw new HandlerRegistrationException("The handler with identifier " + tmpHandler.getIdentifier() + " is already registered for the event " + eventType);
            }
            handlers.add(handler);
        } else {
            ArrayList<SHandler<SEvent>> newHandlerList = new ArrayList<SHandler<SEvent>>(3);
            newHandlerList.add(handler);
            this.registeredHandlers.put(eventType, newHandlerList);
        }
    }

    @Override
    protected void removeAllHandlersFor(SHandler<SEvent> handler) {
        for (String eventType : this.registeredHandlers.keySet()) {
            try {
                this.removeHandler(eventType, handler);
            }
            catch (HandlerUnregistrationException e) {}
        }
    }

    @Override
    protected void removeHandlerFor(String eventType, SHandler<SEvent> h) throws HandlerUnregistrationException {
        boolean removed = false;
        Collection<SHandler<SEvent>> handlers = this.getHandlersFor(eventType);
        if (handlers != null) {
            Iterator<SHandler<SEvent>> it = handlers.iterator();
            while (!removed && it.hasNext()) {
                SHandler<SEvent> handler = it.next();
                if (!h.getIdentifier().equals(handler.getIdentifier())) continue;
                it.remove();
                removed = true;
            }
        }
        if (!removed) {
            throw new HandlerUnregistrationException();
        }
    }
}

