/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.execution.state.CompletingActivityStateImpl;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class CompletingCallActivityStateImpl
extends CompletingActivityStateImpl {
    private final OperationService operationService;
    private final ProcessInstanceService processInstanceService;
    private final DataInstanceService dataInstanceService;
    private final TechnicalLoggerService logger;
    private final ArchiveService archiveService;
    private final SCommentService commentService;
    private final ProcessDefinitionService processDefinitionService;
    private final ConnectorInstanceService connectorInstanceService;
    private final DocumentService documentService;

    public CompletingCallActivityStateImpl(StateBehaviors stateBehaviors, OperationService operationService, ProcessInstanceService processInstanceService, DataInstanceService dataInstanceService, DocumentService documentService, TechnicalLoggerService logger, ArchiveService archiveService, SCommentService commentService, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService) {
        super(stateBehaviors);
        this.operationService = operationService;
        this.processInstanceService = processInstanceService;
        this.dataInstanceService = dataInstanceService;
        this.documentService = documentService;
        this.logger = logger;
        this.archiveService = archiveService;
        this.commentService = commentService;
        this.processDefinitionService = processDefinitionService;
        this.connectorInstanceService = connectorInstanceService;
    }

    @Override
    protected void onEnterToOnFinish(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.executeDataOutputOperations(processDefinition, flowNodeInstance);
        this.stateBehaviors.executeOperations(processDefinition, (SActivityInstance)flowNodeInstance);
    }

    private void executeDataOutputOperations(SProcessDefinition processDefinition, SFlowNodeInstance instance) throws SActivityStateExecutionException {
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SCallActivityDefinition callActivityDef = (SCallActivityDefinition)processContainer.getFlowNode(instance.getFlowNodeDefinitionId());
        try {
            SProcessInstance childProcInst = this.processInstanceService.getChildOfActivity(instance.getId());
            SExpressionContext expressionContext = new SExpressionContext((Long)childProcInst.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), childProcInst.getProcessDefinitionId());
            expressionContext.setParentProcessDefinitionId(instance.getProcessDefinitionId());
            this.operationService.execute(callActivityDef.getDataOutputOperations(), instance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), expressionContext);
            ProcessArchiver.archiveProcessInstance(childProcInst, this.archiveService, this.processInstanceService, this.dataInstanceService, this.documentService, this.logger, this.commentService, this.processDefinitionService, this.connectorInstanceService);
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    @Override
    public int getId() {
        return 30;
    }
}

