/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.impl.condition.BinaryComparatorExecutor;
import org.bonitasoft.engine.expression.impl.condition.LogicalComplementExecutor;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class ConditionExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    public static final String LOGICAL_COMPLEMENT_OPERATOR = "!";
    public static final String NOT_EQUALS_COMPARATOR = "!=";
    public static final String EQUALS_COMPARATOR = "==";
    public static final String GREATER_THAN_OR_EQUALS_COMPARATOR = ">=";
    public static final String lESS_THAN_OR_EQUALS_COMPARATOR = "<=";
    public static final String GREATER_THAN_COMPARATOR = ">";
    public static final String LESS_THAN_COMPARATOR = "<";
    private final List<String> validOperators;
    private final LogicalComplementExecutor logicalComplementExecutor;
    private final BinaryComparatorExecutor binaryComparatorExecutor;

    public ConditionExpressionExecutorStrategy(LogicalComplementExecutor logicalComplementExecutor, BinaryComparatorExecutor binaryComparatorExecutor) {
        this.logicalComplementExecutor = logicalComplementExecutor;
        this.binaryComparatorExecutor = binaryComparatorExecutor;
        this.validOperators = new ArrayList<String>(7);
        this.validOperators.add(LESS_THAN_COMPARATOR);
        this.validOperators.add(GREATER_THAN_COMPARATOR);
        this.validOperators.add(lESS_THAN_OR_EQUALS_COMPARATOR);
        this.validOperators.add(GREATER_THAN_OR_EQUALS_COMPARATOR);
        this.validOperators.add(EQUALS_COMPARATOR);
        this.validOperators.add(NOT_EQUALS_COMPARATOR);
        this.validOperators.add(LOGICAL_COMPLEMENT_OPERATOR);
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        String content = expression.getContent();
        Boolean result = LOGICAL_COMPLEMENT_OPERATOR.equals(content) ? this.logicalComplementExecutor.evaluate(resolvedExpressions, expression) : this.binaryComparatorExecutor.evaluate(resolvedExpressions, expression);
        return result;
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        super.validate(expression);
        if (!this.validOperators.contains(expression.getContent())) {
            throw new SInvalidExpressionException("The content of expression must be among: " + this.validOperators + " for expression: " + expression.toString(), expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return new ExpressionKind("TYPE_CONDITION");
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> evaluatedExpressions = new ArrayList<Object>(expressions.size());
        for (SExpression sExpression : expressions) {
            evaluatedExpressions.add(this.evaluate(sExpression, context, resolvedExpressions, containerState));
        }
        return evaluatedExpressions;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

