/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.synchro.FlowNodeReachStateHandler;
import org.bonitasoft.engine.synchro.ProcessInstanceFinishedHandler;
import org.bonitasoft.engine.synchro.TaskReadyHandler;

public class AddPerfHandlerCommand
extends TenantCommand {
    private static final String PROCESSINSTANCE_STATE_UPDATED = "PROCESSINSTANCE_STATE_UPDATED";
    private static final String ACTIVITYINSTANCE_STATE_UPDATED = "ACTIVITYINSTANCE_STATE_UPDATED";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandExecutionException {
        EventService eventService = serviceAccessor.getEventService();
        Long messageTimeout = (Long)parameters.get("timeout");
        try {
            long tenantId = serviceAccessor.getTenantId();
            if (!this.containsHandler(eventService, PROCESSINSTANCE_STATE_UPDATED, ProcessInstanceFinishedHandler.class)) {
                eventService.addHandler(PROCESSINSTANCE_STATE_UPDATED, new ProcessInstanceFinishedHandler(tenantId, messageTimeout));
            }
            if (!this.containsHandler(eventService, ACTIVITYINSTANCE_STATE_UPDATED, TaskReadyHandler.class)) {
                eventService.addHandler(ACTIVITYINSTANCE_STATE_UPDATED, new TaskReadyHandler(tenantId, messageTimeout));
            }
            if (!this.containsHandler(eventService, ACTIVITYINSTANCE_STATE_UPDATED, FlowNodeReachStateHandler.class)) {
                eventService.addHandler(ACTIVITYINSTANCE_STATE_UPDATED, new FlowNodeReachStateHandler(tenantId, messageTimeout, 3));
            }
            EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
            entityUpdateDescriptor.addField("system", true);
            CommandService commandService = serviceAccessor.getCommandService();
            List commandIds = (List)((Object)parameters.get("commands"));
            for (Long commandId : commandIds) {
                commandService.update(commandService.get(commandId), entityUpdateDescriptor);
            }
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return null;
    }

    private boolean containsHandler(EventService eventService, String eventType, Class<?> clazz) {
        Set<SHandler<SEvent>> handlers = eventService.getHandlers(eventType);
        if (handlers != null) {
            for (SHandler<SEvent> sHandler : handlers) {
                if (!clazz.isInstance(sHandler)) continue;
                return true;
            }
        }
        return false;
    }
}

