/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.work.BonitaExecutorService;

public class BonitaThreadPoolExecutor
extends ThreadPoolExecutor
implements BonitaExecutorService {
    private final BlockingQueue<Runnable> workQueue;
    private final TechnicalLoggerService logger;

    public BonitaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, TechnicalLoggerService logger) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.workQueue = workQueue;
        this.logger = logger;
    }

    @Override
    public void clearAllQueues() {
        this.workQueue.clear();
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (!this.isShutdown()) {
            this.execute(task);
        }
        return null;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("Use submit(Runnable)");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("Use submit(Runnable)");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("Use stop instead");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("Use stop instead");
    }

    @Override
    public void shutdownAndEmptyQueue() {
        super.shutdown();
        this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Clearing queue of work, had " + this.workQueue.size() + " elements");
        this.workQueue.clear();
    }

    @Override
    public void notifyNodeStopped(String nodeName) {
    }
}

