/**
 * Copyright (C) 2011 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.commons;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {

    public static Map<String, Object> buildSimpleMap(final String key, final Object value) {
        final Map<String, Object> result = new HashMap<String, Object>();
        result.put(key, value);
        return result;
    }

    public static <T> Set<T> buildHashSetFromList(final Class<T> clazz, final List<T> list) {
        final Set<T> set = new HashSet<T>();
        set.addAll(list);
        return set;

    }

    public static <T> List<T> emptyOrUnmodifiable(final List<T> list) {
        return list == null ? Collections.<T> emptyList() : Collections.unmodifiableList(list);
    }
}
