/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.DocumentAPI;
import org.bonitasoft.engine.api.impl.APIUtils;
import org.bonitasoft.engine.api.impl.OrderAndFields;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByNameAtProcessInstantiation;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.ArchivedDocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentAttachmentException;
import org.bonitasoft.engine.bpm.document.DocumentCriterion;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.api.impl.DocumentHelper;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.persistence.OrderAndField;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.document.SearchArchivedDocuments;
import org.bonitasoft.engine.search.document.SearchArchivedDocumentsSupervisedBy;
import org.bonitasoft.engine.search.document.SearchDocuments;
import org.bonitasoft.engine.search.document.SearchDocumentsSupervisedBy;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class DocumentAPIImpl
implements DocumentAPI {
    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        DocumentValue documentValue = new DocumentValue(url);
        documentValue.setFileName(fileName);
        documentValue.setMimeType(mimeType);
        try {
            return this.addDocument(processInstanceId, documentName, null, documentValue);
        }
        catch (BonitaException e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    public Document addDocument(long processInstanceId, String documentName, String description, DocumentValue documentValue) throws DocumentAttachmentException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        DocumentHelper documentHelper = new DocumentHelper(documentService, tenantAccessor.getProcessDefinitionService(), tenantAccessor.getProcessInstanceService());
        SDocument sDocument = this.buildSDocument(documentValue);
        int index = documentValue.getIndex();
        try {
            if (documentHelper.isListDefinedInDefinition(documentName, processInstanceId)) {
                List<SMappedDocument> allDocumentOfTheList = documentHelper.getAllDocumentOfTheList(processInstanceId, documentName);
                if (index == -1) {
                    index = allDocumentOfTheList.size();
                } else {
                    if (index > allDocumentOfTheList.size()) {
                        throw new DocumentAttachmentException("Can't attach a document on the list " + documentName + " on process instance " + processInstanceId + " the index is out of range, list size is " + allDocumentOfTheList.size());
                    }
                    for (int i = index; i < allDocumentOfTheList.size(); ++i) {
                        documentService.updateDocumentIndex(allDocumentOfTheList.get(i), i + 1);
                    }
                }
            } else if (index >= 0) {
                throw new DocumentAttachmentException("Unable to add a document with an index if it is a single document");
            }
            SMappedDocument mappedDocument = documentService.attachDocumentToProcessInstance(sDocument, processInstanceId, documentName, description, index);
            return ModelConvertor.toDocument(mappedDocument, documentService);
        }
        catch (SObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage());
        }
        catch (SBonitaException e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    public Document updateDocument(long documentId, DocumentValue documentValue) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            SMappedDocument document = documentService.updateDocument(documentId, this.buildSDocument(documentValue));
            return ModelConvertor.toDocument(document, documentService);
        }
        catch (SBonitaException e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    private SDocument buildSDocument(DocumentValue documentValue) {
        if (documentValue.hasContent()) {
            return this.buildProcessDocument(documentValue.getFileName(), documentValue.getMimeType(), this.getUserId(), documentValue.getContent());
        }
        return this.buildExternalProcessDocumentReference(documentValue.getFileName(), documentValue.getMimeType(), this.getUserId(), documentValue.getUrl());
    }

    private long getUserId() {
        return APIUtils.getUserId();
    }

    private SDocument buildExternalProcessDocumentReference(String fileName, String mimeType, long authorId, String url) {
        return BuilderFactory.get(SDocumentBuilderFactory.class).createNewExternalProcessDocumentReference(fileName, mimeType, authorId, url).done();
    }

    private SDocument buildProcessDocument(String fileName, String mimeType, long authorId, byte[] content) {
        return BuilderFactory.get(SDocumentBuilderFactory.class).createNewProcessDocument(fileName, mimeType, authorId, content).done();
    }

    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent) throws DocumentAttachmentException {
        DocumentValue documentValue = new DocumentValue(documentContent, mimeType, fileName);
        try {
            return this.addDocument(processInstanceId, documentName, null, documentValue);
        }
        catch (BonitaException e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    TenantServiceAccessor getTenantAccessor() {
        return APIUtils.getTenantAccessor();
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        DocumentService documentService = this.getTenantAccessor().getDocumentService();
        try {
            return ModelConvertor.toDocument(documentService.updateDocument(documentService.getMappedDocument(processInstanceId, documentName), this.buildExternalProcessDocumentReference(fileName, mimeType, this.getUserId(), url)), documentService);
        }
        catch (Exception e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String contentFileName, String contentMimeType, byte[] documentContent) throws DocumentAttachmentException {
        DocumentService documentService = this.getTenantAccessor().getDocumentService();
        try {
            return ModelConvertor.toDocument(documentService.updateDocument(documentService.getMappedDocument(processInstanceId, documentName), this.buildProcessDocument(contentFileName, contentMimeType, this.getUserId(), documentContent)), documentService);
        }
        catch (Exception e) {
            throw new DocumentAttachmentException((Throwable)e);
        }
    }

    public Document getDocument(long documentId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return ModelConvertor.toDocument(documentService.getMappedDocument(documentId), documentService);
        }
        catch (SObjectNotFoundException e) {
            throw new DocumentNotFoundException((Throwable)e);
        }
        catch (SBonitaReadException e) {
            throw new DocumentNotFoundException((Throwable)e);
        }
    }

    public List<Document> getLastVersionOfDocuments(long processInstanceId, int pageIndex, int numberPerPage, DocumentCriterion pagingCriterion) throws DocumentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForDocument(pagingCriterion);
        try {
            List<SMappedDocument> mappedDocuments = documentService.getDocumentsOfProcessInstance(processInstanceId, pageIndex, numberPerPage, orderAndField.getField(), orderAndField.getOrder());
            if (mappedDocuments != null && !mappedDocuments.isEmpty()) {
                ArrayList<Document> result = new ArrayList<Document>(mappedDocuments.size());
                for (SMappedDocument mappedDocument : mappedDocuments) {
                    result.add(ModelConvertor.toDocument(mappedDocument, documentService));
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (SBonitaReadException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public byte[] getDocumentContent(String documentStorageId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return documentService.getDocumentContent(documentStorageId);
        }
        catch (SObjectNotFoundException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getLastDocument(long processInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return ModelConvertor.toDocument(documentService.getMappedDocument(processInstanceId, documentName), documentService);
        }
        catch (SObjectNotFoundException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
        catch (SBonitaReadException e) {
            throw new DocumentNotFoundException((Throwable)e);
        }
    }

    public long getNumberOfDocuments(long processInstanceId) throws DocumentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return documentService.getNumberOfDocumentsOfProcessInstance(processInstanceId);
        }
        catch (SBonitaReadException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public Document getDocumentAtProcessInstantiation(long processInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetDocumentByNameAtProcessInstantiation transactionContent = new GetDocumentByNameAtProcessInstantiation(documentService, processInstanceService, tenantAccessor.getProcessDefinitionService(), searchEntitiesDescriptor, processInstanceId, documentName);
            transactionContent.execute();
            SMappedDocument attachment = transactionContent.getResult();
            return ModelConvertor.toDocument(attachment, documentService);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getDocumentAtActivityInstanceCompletion(long activityInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SAActivityInstance instance = activityInstanceService.getMostRecentArchivedActivityInstance(activityInstanceId);
            SMappedDocument document = documentService.getMappedDocument(instance.getRootContainerId(), documentName, instance.getArchiveDate());
            return ModelConvertor.toDocument(document, documentService);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public SearchResult<Document> searchDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        SearchDocuments searchDocuments = new SearchDocuments(documentService, searchEntitiesDescriptor.getSearchDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<Document> searchDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        SearchDocumentsSupervisedBy searchDocuments = new SearchDocumentsSupervisedBy(documentService, searchEntitiesDescriptor.getSearchDocumentDescriptor(), searchOptions, userId);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        SearchArchivedDocuments searchDocuments = new SearchArchivedDocuments(documentService, searchEntitiesDescriptor.getSearchArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        SearchArchivedDocumentsSupervisedBy searchDocuments = new SearchArchivedDocumentsSupervisedBy(userId, documentService, searchEntitiesDescriptor.getSearchArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public ArchivedDocument getArchivedVersionOfProcessDocument(long sourceObjectId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return ModelConvertor.toArchivedDocument(documentService.getArchivedVersionOfProcessDocument(sourceObjectId), documentService);
        }
        catch (SObjectNotFoundException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
    }

    public ArchivedDocument getArchivedProcessDocument(long archivedProcessDocumentId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            return ModelConvertor.toArchivedDocument(documentService.getArchivedDocument(archivedProcessDocumentId), documentService);
        }
        catch (SObjectNotFoundException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
    }

    public Document removeDocument(long documentId) throws DocumentNotFoundException, DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        DocumentHelper documentHelper = new DocumentHelper(documentService, tenantAccessor.getProcessDefinitionService(), tenantAccessor.getProcessInstanceService());
        try {
            SMappedDocument document = documentService.getMappedDocument(documentId);
            int index = document.getIndex();
            if (index != -1) {
                List<SMappedDocument> allDocumentOfTheList = documentHelper.getAllDocumentOfTheList(document.getProcessInstanceId(), document.getName());
                for (int i = index + 1; i < allDocumentOfTheList.size(); ++i) {
                    documentService.updateDocumentIndex(allDocumentOfTheList.get(i), i - 1);
                }
            }
            documentService.removeCurrentVersion(document);
            return ModelConvertor.toDocument(document, documentService);
        }
        catch (SObjectNotFoundException e) {
            throw new DocumentNotFoundException("Unable to delete the document " + documentId + " because it does not exists", (Throwable)e);
        }
        catch (SBonitaException e) {
            throw new DeletionException("Unable to delete the document " + documentId, (Throwable)e);
        }
    }

    public List<Document> getDocumentList(long processInstanceId, String name, int fromIndex, int numberOfResult) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        DocumentHelper documentHelper = new DocumentHelper(documentService, processDefinitionService, processInstanceService);
        try {
            List<SMappedDocument> documentList = documentService.getDocumentList(name, processInstanceId, fromIndex, numberOfResult);
            if (documentList.isEmpty() && !documentHelper.isListDefinedInDefinition(name, processInstanceId)) {
                throw new DocumentNotFoundException("doc not found");
            }
            return ModelConvertor.toDocuments(documentList, documentService);
        }
        catch (SObjectNotFoundException e) {
            throw new DocumentNotFoundException((Throwable)e);
        }
        catch (SBonitaReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void setDocumentList(long processInstanceId, String name, List<DocumentValue> documentsValues) throws DocumentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DocumentHelper documentHelper = new DocumentHelper(tenantAccessor.getDocumentService(), tenantAccessor.getProcessDefinitionService(), tenantAccessor.getProcessInstanceService());
        try {
            documentHelper.setDocumentList(documentsValues, name, processInstanceId, this.getUserId());
        }
        catch (SBonitaException e) {
            throw new DocumentException("Unable to set the list " + name + " on process instance " + processInstanceId, (Exception)e);
        }
    }

    public void deleteContentOfArchivedDocument(long archivedDocumentId) throws DocumentException, DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = APIUtils.getTenantAccessor();
        DocumentService documentService = tenantAccessor.getDocumentService();
        try {
            documentService.deleteContentOfArchivedDocument(archivedDocumentId);
        }
        catch (SObjectNotFoundException e) {
            throw new DocumentNotFoundException("The document with id " + archivedDocumentId + " could not be found", (Throwable)e);
        }
        catch (SBonitaException e) {
            throw new DocumentException("Unable to delete content of all version of the document " + archivedDocumentId, (Exception)e);
        }
    }
}

