/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.flownode;

import org.bonitasoft.engine.api.impl.connector.ConnectorResetStrategy;
import org.bonitasoft.engine.bpm.flownode.ActivityExecutionException;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;

public class FlowNodeRetrier {
    private final ContainerRegistry containerRegistry;
    private final FlowNodeExecutor flowNodeExecutor;
    private final ActivityInstanceService activityInstanceService;
    private final FlowNodeStateManager stateManager;
    private final ConnectorResetStrategy strategy;

    public FlowNodeRetrier(ContainerRegistry containerRegistry, FlowNodeExecutor flowNodeExecutor, ActivityInstanceService activityInstanceService, FlowNodeStateManager stateManager, ConnectorResetStrategy strategy) {
        this.containerRegistry = containerRegistry;
        this.flowNodeExecutor = flowNodeExecutor;
        this.activityInstanceService = activityInstanceService;
        this.stateManager = stateManager;
        this.strategy = strategy;
    }

    public void retry(long flowNodeInstanceId) throws ActivityExecutionException, ActivityInstanceNotFoundException {
        try {
            SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            FlowNodeState previousState = this.stateManager.getState(flowNodeInstance.getPreviousStateId());
            this.validateCurrentState(flowNodeInstance);
            this.strategy.resetConnectorsOf(flowNodeInstanceId);
            this.flowNodeExecutor.setStateByStateId(flowNodeInstance.getProcessDefinitionId(), flowNodeInstanceId, flowNodeInstance.getPreviousStateId());
            if (!previousState.isTerminal()) {
                this.containerRegistry.executeFlowNode(flowNodeInstance.getProcessDefinitionId(), flowNodeInstance.getParentProcessInstanceId(), flowNodeInstanceId, null, null);
            }
        }
        catch (SFlowNodeNotFoundException e) {
            throw new ActivityInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ActivityExecutionException((Throwable)e);
        }
    }

    private void validateCurrentState(SFlowNodeInstance flowNodeInstance) throws ActivityExecutionException {
        FlowNodeState currentState = this.stateManager.getState(flowNodeInstance.getStateId());
        if (!"failed".equals(currentState.getName())) {
            throw new ActivityExecutionException("Unable to retry the flow node instance [name=" + flowNodeInstance.getName() + ", id=" + flowNodeInstance.getId() + "] because it is not in failed state. The current state for this flow node instance is '" + currentState.getName() + "'");
        }
    }
}

