/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.xml.Actor;
import org.bonitasoft.engine.actor.xml.ActorMapping;
import org.bonitasoft.engine.actor.xml.ActorMappingNodeBuilder;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.xml.XMLNode;
import org.bonitasoft.engine.xml.XMLWriter;

public class ExportActorMapping
implements TransactionContentWithResult<String> {
    private final ActorMappingService actorMappingService;
    private final IdentityService identityService;
    private final XMLWriter writer;
    private final long processDefinitionId;
    private String xmlContent;

    public ExportActorMapping(ActorMappingService actorMappingService, IdentityService identityService, XMLWriter writer, long processDefinitionId) {
        this.actorMappingService = actorMappingService;
        this.identityService = identityService;
        this.writer = writer;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void execute() throws SBonitaException {
        ActorMapping mapping = this.getActorMapping();
        XMLNode node = this.getNode(mapping);
        byte[] bytes = this.writer.write(node);
        this.xmlContent = new String(bytes);
    }

    private ActorMapping getActorMapping() throws SBonitaException {
        ActorMapping actorMapping = new ActorMapping();
        QueryOptions queryOptions = new QueryOptions(0, 100, SActor.class, "id", OrderByType.ASC);
        List<SActor> actors = this.actorMappingService.getActors(this.processDefinitionId, queryOptions);
        while (!actors.isEmpty()) {
            for (SActor sActor : actors) {
                Actor actor = new Actor(sActor.getName());
                List<SActorMember> actorMembers = this.actorMappingService.getActorMembers(sActor.getId(), 0, Integer.MAX_VALUE);
                for (SActorMember sActorMember : actorMembers) {
                    this.addUser(actor, sActorMember);
                    this.addGroup(actor, sActorMember);
                    this.addRole(actor, sActorMember);
                    this.addMembership(actor, sActorMember);
                }
                actorMapping.addActor(actor);
            }
            queryOptions = QueryOptions.getNextPage(queryOptions);
            actors = this.actorMappingService.getActors(this.processDefinitionId, queryOptions);
        }
        return actorMapping;
    }

    private void addUser(Actor actor, SActorMember sActorMember) throws SUserNotFoundException {
        if (sActorMember.getUserId() > 0L) {
            SUser user = this.identityService.getUser(sActorMember.getUserId());
            actor.addUser(user.getUserName());
        }
    }

    private void addGroup(Actor actor, SActorMember sActorMember) throws SGroupNotFoundException {
        if (sActorMember.getGroupId() > 0L && sActorMember.getRoleId() <= 0L) {
            SGroup group = this.identityService.getGroup(sActorMember.getGroupId());
            actor.addGroup(group.getPath());
        }
    }

    private void addRole(Actor actor, SActorMember sActorMember) throws SRoleNotFoundException {
        if (sActorMember.getRoleId() > 0L && sActorMember.getGroupId() <= 0L) {
            SRole role = this.identityService.getRole(sActorMember.getRoleId());
            actor.addRole(role.getName());
        }
    }

    private void addMembership(Actor actor, SActorMember sActorMember) throws SRoleNotFoundException, SGroupNotFoundException {
        if (sActorMember.getRoleId() > 0L && sActorMember.getGroupId() > 0L) {
            SRole role = this.identityService.getRole(sActorMember.getRoleId());
            SGroup group = this.identityService.getGroup(sActorMember.getGroupId());
            actor.addMembership(group.getPath(), role.getName());
        }
    }

    private XMLNode getNode(ActorMapping mapping) {
        return ActorMappingNodeBuilder.getDocument(mapping);
    }

    @Override
    public String getResult() {
        return this.xmlContent;
    }
}

