/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.profile.ProfileService;

public class DeleteRoles
extends DeleteWithActorMembers
implements TransactionContent {
    private final List<Long> roleIds;

    public DeleteRoles(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> roleIds) {
        super(actorMappingService, profileService, identityService);
        this.roleIds = roleIds;
    }

    @Override
    public void execute() throws SBonitaException {
        for (Long roleId : this.roleIds) {
            this.deleteMembershipsByRole(roleId);
            this.deleteActorMembersOfRole(roleId);
            this.deleteProfileMembersOfRole(roleId);
            this.getIdentityService().deleteRole(roleId);
        }
    }
}

