/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.io.Serializable;
import java.util.List;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;

public class GetArchivedProcessInstanceList
implements TransactionContentWithResult<List<ArchivedProcessInstance>> {
    private final ProcessInstanceService processInstanceService;
    private final SearchEntitiesDescriptor searchEntitiesDescriptor;
    private final SearchOptionsBuilder searchOptionsBuilder;
    private List<ArchivedProcessInstance> processInstanceList;
    private final ProcessDefinitionService processDefinitionService;

    public GetArchivedProcessInstanceList(ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, SearchEntitiesDescriptor searchEntitiesDescriptor, long processInstanceId, int startIndex, int maxResults) {
        this.processInstanceService = processInstanceService;
        this.processDefinitionService = processDefinitionService;
        this.searchEntitiesDescriptor = searchEntitiesDescriptor;
        this.searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        this.searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(processInstanceId));
    }

    public GetArchivedProcessInstanceList(ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, SearchEntitiesDescriptor searchEntitiesDescriptor, long processInstanceId, int startIndex, int maxResults, String field, OrderByType order) {
        this(processInstanceService, processDefinitionService, searchEntitiesDescriptor, processInstanceId, startIndex, maxResults);
        this.searchOptionsBuilder.sort(field, Order.valueOf((String)order.name()));
    }

    public GetArchivedProcessInstanceList(ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, SearchEntitiesDescriptor searchEntitiesDescriptor, SearchOptions searchOptions) {
        this.processInstanceService = processInstanceService;
        this.processDefinitionService = processDefinitionService;
        this.searchEntitiesDescriptor = searchEntitiesDescriptor;
        this.searchOptionsBuilder = new SearchOptionsBuilder(searchOptions);
    }

    @Override
    public void execute() throws SBonitaException {
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(this.processInstanceService, this.processDefinitionService, this.searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), this.searchOptionsBuilder.done());
        searchArchivedProcessInstances.execute();
        this.processInstanceList = searchArchivedProcessInstances.getResult().getResult();
    }

    @Override
    public List<ArchivedProcessInstance> getResult() {
        return this.processInstanceList;
    }
}

