/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilder;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SDocumentListDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public class DocumentHelper {
    private final DocumentService documentService;
    private final ProcessDefinitionService processDefinitionService;
    private final ProcessInstanceService processInstanceService;

    public DocumentHelper(DocumentService documentService, ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService) {
        this.documentService = documentService;
        this.processDefinitionService = processDefinitionService;
        this.processInstanceService = processInstanceService;
    }

    public List<SMappedDocument> getAllDocumentOfTheList(long processInstanceId, String name) throws SBonitaReadException {
        List<SMappedDocument> mappedDocuments;
        QueryOptions queryOptions = new QueryOptions(0, 100);
        ArrayList<SMappedDocument> result = new ArrayList<SMappedDocument>();
        do {
            mappedDocuments = this.documentService.getDocumentList(name, processInstanceId, queryOptions.getFromIndex(), queryOptions.getNumberOfResults());
            result.addAll(mappedDocuments);
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (mappedDocuments.size() == 100);
        return result;
    }

    public boolean isListDefinedInDefinition(String documentName, long processInstanceId) throws SObjectNotFoundException, SBonitaReadException {
        try {
            SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
            SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
            List<SDocumentListDefinition> documentDefinitions = processDefinition.getProcessContainer().getDocumentListDefinitions();
            for (SDocumentListDefinition documentDefinition : documentDefinitions) {
                if (!documentName.equals(documentDefinition.getName())) continue;
                return true;
            }
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new SObjectNotFoundException("Unable to find the list " + documentName + ", nothing in database and the process instance " + processInstanceId + " is not found", e);
        }
        catch (SProcessInstanceReadException e) {
            throw new SBonitaReadException(e);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new SObjectNotFoundException("Unable to find the list " + documentName + " on process instance " + processInstanceId + ", nothing in database and the process definition is not found", e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SBonitaReadException(e);
        }
        return false;
    }

    public SDocument createDocumentObject(DocumentValue documentValue, long authorId) {
        SDocumentBuilder processDocumentBuilder = BuilderFactory.get(SDocumentBuilderFactory.class).createNewInstance(documentValue.getFileName(), documentValue.getMimeType(), authorId);
        processDocumentBuilder.setHasContent(documentValue.hasContent());
        processDocumentBuilder.setURL(documentValue.getUrl());
        processDocumentBuilder.setContent(documentValue.getContent());
        return processDocumentBuilder.done();
    }

    public void deleteDocument(String documentName, long processInstanceId) throws SObjectModificationException {
        try {
            this.documentService.removeCurrentVersion(processInstanceId, documentName);
        }
        catch (SObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void createOrUpdateDocument(DocumentValue newValue, String documentName, long processInstanceId, long authorId) throws SBonitaReadException, SObjectCreationException, SObjectModificationException {
        SDocument document = this.createDocumentObject(newValue, authorId);
        try {
            SMappedDocument mappedDocument = this.documentService.getMappedDocument(processInstanceId, documentName);
            this.documentService.updateDocument(mappedDocument, document);
        }
        catch (SObjectNotFoundException e) {
            this.documentService.attachDocumentToProcessInstance(document, processInstanceId, documentName, null);
        }
    }

    public void setDocumentList(List<DocumentValue> documentList, String documentName, long processInstanceId, long authorId) throws SBonitaReadException, SObjectCreationException, SObjectNotFoundException, SObjectModificationException, SObjectAlreadyExistsException {
        List<SMappedDocument> currentList = this.getExistingDocumentList(documentName, processInstanceId);
        for (int index = 0; index < documentList.size(); ++index) {
            this.processDocumentOnIndex(documentList.get(index), documentName, processInstanceId, currentList, index, authorId);
        }
        this.removeOthersDocuments(currentList);
    }

    void updateExistingDocument(SMappedDocument documentToUpdate, int index, DocumentValue documentValue, long authorId) throws SObjectModificationException {
        if (documentValue.hasChanged()) {
            this.documentService.updateDocumentOfList(documentToUpdate, this.createDocumentObject(documentValue, authorId), index);
        } else if (documentToUpdate.getIndex() != index) {
            this.documentService.updateDocumentIndex(documentToUpdate, index);
        }
    }

    SMappedDocument getDocumentHavingDocumentIdAndRemoveFromList(List<SMappedDocument> currentList, Long documentId, String documentName, Long processInstanceId) throws SObjectNotFoundException {
        Iterator<SMappedDocument> iterator = currentList.iterator();
        while (iterator.hasNext()) {
            SMappedDocument next = iterator.next();
            if (next.getId() != documentId.longValue()) continue;
            iterator.remove();
            return next;
        }
        throw new SObjectNotFoundException("The document with id " + documentId + " was not in the list " + documentName + " of process instance " + processInstanceId);
    }

    List<SMappedDocument> getExistingDocumentList(String documentName, long processInstanceId) throws SBonitaReadException, SObjectNotFoundException {
        List<SMappedDocument> currentList = this.getAllDocumentOfTheList(processInstanceId, documentName);
        if (currentList.isEmpty() && !this.isListDefinedInDefinition(documentName, processInstanceId)) {
            throw new SObjectNotFoundException("Unable to find the list " + documentName + " on process instance " + processInstanceId + ", nothing in database and nothing declared in the definition");
        }
        return currentList;
    }

    void removeOthersDocuments(List<SMappedDocument> currentList) throws SObjectModificationException {
        for (SMappedDocument mappedDocument : currentList) {
            this.documentService.removeCurrentVersion(mappedDocument);
        }
    }

    void processDocumentOnIndex(DocumentValue documentValue, String documentName, long processInstanceId, List<SMappedDocument> currentList, int index, long authorId) throws SObjectCreationException, SObjectAlreadyExistsException, SObjectNotFoundException, SObjectModificationException {
        if (documentValue.getDocumentId() != null) {
            SMappedDocument documentToUpdate = this.getDocumentHavingDocumentIdAndRemoveFromList(currentList, documentValue.getDocumentId(), documentName, processInstanceId);
            this.updateExistingDocument(documentToUpdate, index, documentValue, authorId);
        } else {
            this.documentService.attachDocumentToProcessInstance(this.createDocumentObject(documentValue, authorId), processInstanceId, documentName, null, index);
        }
    }
}

