/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.event.trigger.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.TextDataDefinition;
import org.bonitasoft.engine.bpm.data.XMLDataDefinition;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCorrelationDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SCorrelationDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SEventTriggerDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilderFactory;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilderFactory;

public class SMessageEventTriggerDefinitionImpl
extends SEventTriggerDefinitionImpl
implements SMessageEventTriggerDefinition {
    private static final long serialVersionUID = 4603391860834299674L;
    private String messageName;
    private final List<SCorrelationDefinition> correlations;

    public SMessageEventTriggerDefinitionImpl(String name, List<SCorrelationDefinition> correlations) {
        this.messageName = name;
        this.correlations = correlations;
    }

    public SMessageEventTriggerDefinitionImpl() {
        this.correlations = new ArrayList<SCorrelationDefinition>(1);
    }

    public SMessageEventTriggerDefinitionImpl(SCatchMessageEventTriggerDefinition trigger) {
        this.messageName = trigger.getMessageName();
        this.correlations = trigger.getCorrelations();
    }

    public SMessageEventTriggerDefinitionImpl(MessageEventTriggerDefinition messageEventTrigger) {
        this.messageName = messageEventTrigger.getMessageName();
        this.correlations = new ArrayList<SCorrelationDefinition>(messageEventTrigger.getCorrelations().size());
        for (CorrelationDefinition correlation : messageEventTrigger.getCorrelations()) {
            this.correlations.add(new SCorrelationDefinitionImpl(ServerModelConvertor.convertExpression(correlation.getKey()), ServerModelConvertor.convertExpression(correlation.getValue())));
        }
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public List<SCorrelationDefinition> getCorrelations() {
        return Collections.unmodifiableList(this.correlations);
    }

    public void setMessageName(String name) {
        this.messageName = name;
    }

    public void addCorrelation(SCorrelationDefinition correlation) {
        this.correlations.add(correlation);
    }

    protected SDataDefinition buildSDataDefinition(DataDefinition dataDefinition) {
        if (this.isXMLDataDefinition(dataDefinition)) {
            XMLDataDefinition xmlDataDef = (XMLDataDefinition)dataDefinition;
            SXMLDataDefinitionBuilderFactory fact = BuilderFactory.get(SXMLDataDefinitionBuilderFactory.class);
            SXMLDataDefinitionBuilder builder = fact.createNewXMLData(this.messageName).setElement(xmlDataDef.getElement()).setNamespace(xmlDataDef.getNamespace());
            builder.setDefaultValue(ServerModelConvertor.convertExpression(dataDefinition.getDefaultValueExpression()));
            builder.setDescription(dataDefinition.getDescription());
            builder.setTransient(dataDefinition.isTransientData());
            return builder.done();
        }
        SDataDefinitionBuilderFactory fact = BuilderFactory.get(SDataDefinitionBuilderFactory.class);
        SDataDefinitionBuilder builder = null;
        if (this.isTextDataDefinition(dataDefinition)) {
            TextDataDefinition textDataDefinition = (TextDataDefinition)dataDefinition;
            builder = fact.createNewTextData(dataDefinition.getName()).setAsLongText(textDataDefinition.isLongText());
        } else {
            builder = fact.createNewInstance(dataDefinition.getName(), dataDefinition.getClassName());
        }
        builder.setDefaultValue(ServerModelConvertor.convertExpression(dataDefinition.getDefaultValueExpression()));
        builder.setDescription(dataDefinition.getDescription());
        builder.setTransient(dataDefinition.isTransientData());
        return builder.done();
    }

    private boolean isXMLDataDefinition(DataDefinition dataDefinition) {
        return dataDefinition instanceof XMLDataDefinition;
    }

    private boolean isTextDataDefinition(DataDefinition dataDefinition) {
        return dataDefinition instanceof TextDataDefinition;
    }

    @Override
    public SEventTriggerType getEventTriggerType() {
        return SEventTriggerType.MESSAGE;
    }
}

