/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.execution.Validator;

public class AdvancedStartProcessValidator
implements Validator<List<String>> {
    private final ProcessDefinitionService processDefinitionService;
    private final long processDefinitionId;

    public AdvancedStartProcessValidator(ProcessDefinitionService processDefinitionService, long processDefinitionId) {
        this.processDefinitionService = processDefinitionService;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public List<String> validate(List<String> flowNodeNames) throws SBonitaException {
        ArrayList<String> problems = new ArrayList<String>();
        if (flowNodeNames.isEmpty()) {
            problems.add("The list of activity names to start cannot be empty!");
        }
        ArrayList<String> foundFlowNodes = new ArrayList<String>(flowNodeNames.size());
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(this.processDefinitionId);
        for (SFlowNodeDefinition flowNode : processDefinition.getProcessContainer().getFlowNodes()) {
            boolean invalidType;
            boolean bl = invalidType = SFlowNodeType.BOUNDARY_EVENT.equals((Object)flowNode.getType()) || SFlowNodeType.SUB_PROCESS.equals((Object)flowNode.getType()) || SFlowNodeType.GATEWAY.equals((Object)flowNode.getType());
            if (!flowNodeNames.contains(flowNode.getName())) continue;
            foundFlowNodes.add(flowNode.getName());
            if (!invalidType) continue;
            problems.add(this.buildInvalidTypeErroMessage(processDefinition, flowNode));
        }
        problems.addAll(this.checkForNotFoundFlowNodes(flowNodeNames, foundFlowNodes, processDefinition));
        return problems;
    }

    private List<String> checkForNotFoundFlowNodes(List<String> flowNodeNames, List<String> foundFlowNodes, SProcessDefinition processDefinition) {
        ArrayList<String> problems = new ArrayList<String>();
        for (String flowNodeName : flowNodeNames) {
            if (foundFlowNodes.contains(flowNodeName)) continue;
            problems.add(this.buildFlowNodeNotFoundErroMessage(processDefinition, flowNodeName));
        }
        return problems;
    }

    private String buildInvalidTypeErroMessage(SProcessDefinition processDefinition, SFlowNodeDefinition flowNode) {
        StringBuilder stb = new StringBuilder();
        stb.append("'");
        stb.append(flowNode.getName());
        stb.append("' is not a valide start point for the process ");
        stb.append(this.buildProcessContext(processDefinition));
        stb.append(" You cannot start a process from a gateway, a boundary event or an event sub-process");
        return stb.toString();
    }

    private String buildFlowNodeNotFoundErroMessage(SProcessDefinition processDefinition, String flowNodeName) {
        StringBuilder stb = new StringBuilder();
        stb.append("No flownode named '");
        stb.append(flowNodeName);
        stb.append("' was found in the process");
        stb.append(this.buildProcessContext(processDefinition));
        return stb.toString();
    }

    private String buildProcessContext(SProcessDefinition processDefinition) {
        StringBuilder stb = new StringBuilder();
        stb.append("<id: ");
        stb.append(this.processDefinitionId);
        stb.append(", name: ");
        stb.append(processDefinition.getName());
        stb.append(", version: ");
        stb.append(processDefinition.getVersion());
        stb.append(">.");
        return stb.toString();
    }
}

