/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.api.impl.transaction.event.CreateEventInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinitionWithInputValues;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.InvalidEvaluationConnectorConditionException;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilderFactory;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentListDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.TransitionState;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionCreationException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.HandlerRegistrationException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.Filter;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.FlowNodeIdFilter;
import org.bonitasoft.engine.execution.FlowNodeSelector;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StartFlowNodeFilter;
import org.bonitasoft.engine.execution.TransitionEvaluator;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.handler.SProcessInstanceHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class ProcessExecutorImpl
implements ProcessExecutor {
    protected final ActivityInstanceService activityInstanceService;
    private final FlowNodeExecutor flowNodeExecutor;
    private final TechnicalLoggerService logger;
    protected final ProcessInstanceService processInstanceService;
    private final WorkService workService;
    private final ProcessDefinitionService processDefinitionService;
    private final GatewayInstanceService gatewayInstanceService;
    private final TransitionService transitionService;
    private final EventInstanceService eventInstanceService;
    protected final ClassLoaderService classLoaderService;
    protected final ExpressionResolverService expressionResolverService;
    protected final ConnectorService connectorService;
    private final OperationService operationService;
    private final DocumentService documentService;
    private final ReadSessionAccessor sessionAccessor;
    protected final BPMInstancesCreator bpmInstancesCreator;
    protected final EventsHandler eventsHandler;
    private final ConnectorInstanceService connectorInstanceService;
    private final TransitionEvaluator transitionEvaluator;

    public ProcessExecutorImpl(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, TechnicalLoggerService logger, FlowNodeExecutor flowNodeExecutor, WorkService workService, ProcessDefinitionService processDefinitionService, GatewayInstanceService gatewayInstanceService, TransitionService transitionService, EventInstanceService eventInstanceService, ConnectorService connectorService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, OperationService operationService, ExpressionResolverService expressionResolverService, EventService eventService, Map<String, SProcessInstanceHandler<SEvent>> handlers, DocumentService documentService, ReadSessionAccessor sessionAccessor, ContainerRegistry containerRegistry, BPMInstancesCreator bpmInstancesCreator, EventsHandler eventsHandler, FlowNodeStateManager flowNodeStateManager, TransitionEvaluator transitionEvaluator) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.logger = logger;
        this.flowNodeExecutor = flowNodeExecutor;
        this.workService = workService;
        this.processDefinitionService = processDefinitionService;
        this.gatewayInstanceService = gatewayInstanceService;
        this.transitionService = transitionService;
        this.eventInstanceService = eventInstanceService;
        this.connectorService = connectorService;
        this.classLoaderService = classLoaderService;
        this.operationService = operationService;
        this.expressionResolverService = expressionResolverService;
        this.documentService = documentService;
        this.sessionAccessor = sessionAccessor;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.eventsHandler = eventsHandler;
        this.transitionEvaluator = transitionEvaluator;
        flowNodeStateManager.setProcessExecutor(this);
        eventsHandler.setProcessExecutor(this);
        for (Map.Entry<String, SProcessInstanceHandler<SEvent>> handler : handlers.entrySet()) {
            try {
                eventService.addHandler(handler.getKey(), (SHandler<SEvent>)handler.getValue());
            }
            catch (HandlerRegistrationException e) {
                if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage());
                }
                if (!logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
                logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
        }
        containerRegistry.addContainerExecutor(this);
    }

    @Override
    public FlowNodeState executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, long processInstanceId, Long executerId, Long executerSubstituteId) throws SFlowNodeExecutionException {
        return this.flowNodeExecutor.stepForward(flowNodeInstanceId, contextDependency, operations, processInstanceId, executerId, executerSubstituteId);
    }

    private SConnectorInstance getNextConnectorInstance(SProcessInstance processInstance, ConnectorEvent event) throws SConnectorInstanceReadException {
        List<SConnectorInstance> connectorInstances = this.connectorInstanceService.getConnectorInstances(processInstance.getId(), "process", event, 0, 1, "TO_BE_EXECUTED");
        return connectorInstances.size() == 1 ? connectorInstances.get(0) : null;
    }

    @Override
    public boolean executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, ConnectorEvent activationEvent, FlowNodeSelector selectorForConnectorOnEnter) throws SBonitaException {
        SConnectorInstance nextConnectorInstance;
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        long processDefinitionId = processDefinition.getId();
        List<SConnectorDefinition> connectors = processContainer.getConnectors(activationEvent);
        if (connectors.size() > 0 && (nextConnectorInstance = this.getNextConnectorInstance(sProcessInstance, activationEvent)) != null) {
            for (SConnectorDefinition sConnectorDefinition : connectors) {
                if (!sConnectorDefinition.getName().equals(nextConnectorInstance.getName())) continue;
                this.workService.registerWork(WorkFactory.createExecuteConnectorOfProcess(processDefinitionId, sProcessInstance.getId(), sProcessInstance.getRootProcessInstanceId(), nextConnectorInstance.getId(), sConnectorDefinition.getName(), activationEvent, selectorForConnectorOnEnter));
                return true;
            }
        }
        return false;
    }

    private List<SFlowNodeInstance> initializeFirstExecutableElements(SProcessInstance sProcessInstance, FlowNodeSelector selector) {
        try {
            List<SFlowNodeDefinition> flownNodeDefinitions = selector.getFilteredElements();
            long rootProcessInstanceId = sProcessInstance.getRootProcessInstanceId();
            if (rootProcessInstanceId <= 0L) {
                rootProcessInstanceId = sProcessInstance.getId();
            }
            return this.bpmInstancesCreator.createFlowNodeInstances(selector.getProcessDefinition().getId(), rootProcessInstanceId, sProcessInstance.getId(), flownNodeDefinitions, rootProcessInstanceId, sProcessInstance.getId(), SStateCategory.NORMAL);
        }
        catch (SBonitaException e) {
            this.setExceptionContext(selector.getProcessDefinition(), sProcessInstance, e);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    private SProcessInstance createProcessInstance(SProcessDefinition sDefinition, long starterId, long starterSubstituteId, long callerId, SFlowNodeType callerType, long rootProcessInstanceId) throws SProcessInstanceCreationException {
        SProcessInstanceBuilder processInstanceBuilder = BuilderFactory.get(SProcessInstanceBuilderFactory.class).createNewInstance(sDefinition).setStartedBy(starterId).setStartedBySubstitute(starterSubstituteId).setCallerId(callerId, callerType).setRootProcessInstanceId(rootProcessInstanceId);
        SProcessInstance sProcessInstance = processInstanceBuilder.done();
        this.processInstanceService.createProcessInstance(sProcessInstance);
        return sProcessInstance;
    }

    protected SProcessInstance createProcessInstance(SProcessDefinition processDefinition, long starterId, long starterSubstituteId, long callerId) throws SProcessInstanceCreationException {
        SActivityInstance callerInstance;
        try {
            callerInstance = this.getCaller(callerId);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException("Unable to get caller.", e);
        }
        if (callerInstance != null) {
            return this.createProcessInstance(processDefinition, starterId, starterSubstituteId, callerId, callerInstance.getType(), callerInstance.getRootContainerId());
        }
        return this.createProcessInstance(processDefinition, starterId, starterSubstituteId, callerId, null, -1L);
    }

    private SActivityInstance getCaller(long callerId) throws SBonitaReadException, SActivityInstanceNotFoundException {
        if (callerId > 0L) {
            return this.activityInstanceService.getActivityInstance(callerId);
        }
        return null;
    }

    private void executeGateway(SProcessDefinition sProcessDefinition, STransitionDefinition sTransitionDefinition, SFlowNodeInstance flowNodeThatTriggeredTheTransition) throws SBonitaException {
        long parentProcessInstanceId = flowNodeThatTriggeredTheTransition.getParentProcessInstanceId();
        long rootProcessInstanceId = flowNodeThatTriggeredTheTransition.getRootProcessInstanceId();
        SFlowNodeDefinition sFlowNodeDefinition = this.processDefinitionService.getNextFlowNode(sProcessDefinition, sTransitionDefinition.getName());
        Long processDefinitionId = sProcessDefinition.getId();
        boolean isGateway = SFlowNodeType.GATEWAY.equals((Object)sFlowNodeDefinition.getType());
        boolean toExecute = false;
        try {
            Long nextFlowNodeInstanceId;
            List<SGatewayInstance> otherMergedGateways = null;
            SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
            SStateCategory stateCategory = parentProcessInstance.getStateCategory();
            if (isGateway) {
                SGatewayInstance gatewayInstance = this.getActivateGateway(sProcessDefinition, sFlowNodeDefinition, stateCategory, parentProcessInstanceId, rootProcessInstanceId);
                this.gatewayInstanceService.hitTransition(gatewayInstance, sFlowNodeDefinition.getTransitionIndex(sTransitionDefinition.getName()));
                nextFlowNodeInstanceId = gatewayInstance.getId();
                if (this.gatewayInstanceService.checkMergingCondition(sProcessDefinition, gatewayInstance)) {
                    otherMergedGateways = this.gatewayInstanceService.setFinishAndCreateNewGatewayForRemainingToken(sProcessDefinition, gatewayInstance);
                    toExecute = true;
                }
            } else {
                SFlowNodeInstance sFlowNodeInstance = this.bpmInstancesCreator.toFlowNodeInstance(processDefinitionId, flowNodeThatTriggeredTheTransition.getRootContainerId(), flowNodeThatTriggeredTheTransition.getParentContainerId(), SFlowElementsContainerType.PROCESS, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, true, -1, stateCategory, -1L);
                new CreateEventInstance((SEventInstance)sFlowNodeInstance, this.eventInstanceService).call();
                nextFlowNodeInstanceId = sFlowNodeInstance.getId();
                toExecute = true;
            }
            if (toExecute) {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, parentProcessInstanceId, nextFlowNodeInstanceId, null, null));
                if (otherMergedGateways != null) {
                    for (SGatewayInstance otherMergedGateway : otherMergedGateways) {
                        this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, parentProcessInstanceId, otherMergedGateway.getId(), null, null));
                    }
                }
            }
        }
        catch (SBonitaException e) {
            this.setExceptionContext(sProcessDefinition, flowNodeThatTriggeredTheTransition, e);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw e;
        }
    }

    private SGatewayInstance getActivateGateway(SProcessDefinition sProcessDefinition, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, long parentProcessInstanceId, long rootProcessInstanceId) throws SBonitaException {
        SGatewayInstance gatewayInstance = null;
        try {
            gatewayInstance = this.gatewayInstanceService.getActiveGatewayInstanceOfTheProcess(parentProcessInstanceId, flowNodeDefinition.getName());
        }
        catch (SGatewayNotFoundException e) {
            return this.createGateway(sProcessDefinition.getId(), flowNodeDefinition, stateCategory, parentProcessInstanceId, rootProcessInstanceId);
        }
        return gatewayInstance;
    }

    private SGatewayInstance createGateway(Long processDefinitionId, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, long parentProcessInstanceId, long rootProcessInstanceId) throws SBonitaException {
        return (SGatewayInstance)this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, SFlowElementsContainerType.PROCESS, flowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, false, 0, stateCategory, -1L);
    }

    protected void executeOperations(List<SOperation> operations, Map<String, Object> context, SExpressionContext expressionContext, SProcessInstance sProcessInstance) throws SBonitaException {
        if (operations != null && !operations.isEmpty()) {
            expressionContext.setInputValues(context);
            if (expressionContext.getContainerId() == null) {
                expressionContext.setContainerId(sProcessInstance.getId());
                expressionContext.setContainerType(DataInstanceContainer.PROCESS_INSTANCE.name());
            }
            this.operationService.execute(operations, sProcessInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), expressionContext);
        }
    }

    protected boolean initialize(long userId, SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, SFlowElementContainerDefinition processContainer, List<ConnectorDefinitionWithInputValues> connectors, FlowNodeSelector selectorForConnectorOnEnter) throws BonitaHomeNotSetException, IOException, InvalidEvaluationConnectorConditionException, SBonitaException {
        this.bpmInstancesCreator.createDataInstances(sProcessInstance, processContainer, sProcessDefinition, expressionContext, operations, context);
        this.createDocuments(sProcessDefinition, sProcessInstance, userId);
        this.createDocumentLists(sProcessDefinition, sProcessInstance, userId, expressionContext, context);
        if (connectors != null) {
            this.executeConnectors(sProcessDefinition, sProcessInstance, connectors);
        }
        if (expressionContext == null) {
            expressionContext = new SExpressionContext();
        }
        this.executeOperations(operations, context, expressionContext, sProcessInstance);
        this.bpmInstancesCreator.createConnectorInstances(sProcessInstance, processContainer.getConnectors(), "process");
        return this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_ENTER, selectorForConnectorOnEnter);
    }

    protected void createDocuments(SProcessDefinition sDefinition, SProcessInstance sProcessInstance, long authorId) throws SObjectCreationException, BonitaHomeNotSetException, STenantIdNotSetException, IOException, SObjectAlreadyExistsException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        List<SDocumentDefinition> documentDefinitions = processContainer.getDocumentDefinitions();
        if (!documentDefinitions.isEmpty()) {
            String processesFolder = BonitaHomeServer.getInstance().getProcessFolder(this.sessionAccessor.getTenantId(), sDefinition.getId());
            File documentsFolder = new File(processesFolder, "documents");
            for (SDocumentDefinition document : documentDefinitions) {
                if (document.getFile() != null) {
                    String file = document.getFile();
                    byte[] content = FileUtils.readFileToByteArray((File)new File(documentsFolder, file));
                    this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), content, authorId, document.getDescription(), -1);
                    continue;
                }
                if (document.getUrl() == null) continue;
                this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), document.getUrl(), authorId, document.getDescription(), -1);
            }
        }
    }

    protected void createDocumentLists(SProcessDefinition sDefinition, SProcessInstance processInstance, long authorId, SExpressionContext expressionContext, Map<String, Object> context) throws SBonitaException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        List<SDocumentListDefinition> documentListDefinitions = processContainer.getDocumentListDefinitions();
        if (!documentListDefinitions.isEmpty()) {
            List<Object> initialValues = this.evaluateInitialExpressionsOfDocumentLists(processInstance, expressionContext, context, documentListDefinitions);
            for (int i = 0; i < documentListDefinitions.size(); ++i) {
                this.attachDocumentForList(processInstance, authorId, (List)initialValues.get(i), documentListDefinitions.get(i));
            }
        }
    }

    private void attachDocumentForList(SProcessInstance processInstance, long authorId, List<DocumentValue> initialValue, SDocumentListDefinition documentListDefinition) throws SObjectCreationException, SObjectAlreadyExistsException {
        if (initialValue != null) {
            for (int index = 0; index < initialValue.size(); ++index) {
                this.attacheDocument(processInstance, authorId, initialValue, documentListDefinition, index);
            }
        }
    }

    private void attacheDocument(SProcessInstance processInstance, long authorId, List<DocumentValue> initialValue, SDocumentListDefinition documentListDefinition, int index) throws SObjectCreationException, SObjectAlreadyExistsException {
        DocumentValue documentValue = initialValue.get(index);
        if (documentValue != null) {
            if (documentValue.hasContent()) {
                this.attachDocument(processInstance.getId(), documentListDefinition.getName(), documentValue.getFileName(), documentValue.getMimeType(), documentValue.getContent(), authorId, documentListDefinition.getDescription(), index);
            } else {
                this.attachDocument(processInstance.getId(), documentListDefinition.getName(), documentValue.getFileName(), documentValue.getMimeType(), documentValue.getUrl(), authorId, documentListDefinition.getDescription(), index);
            }
        }
    }

    private List<Object> evaluateInitialExpressionsOfDocumentLists(SProcessInstance processInstance, SExpressionContext expressionContext, Map<String, Object> context, List<SDocumentListDefinition> documentListDefinitions) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        ArrayList<SExpression> initialValuesExpressions = new ArrayList<SExpression>(documentListDefinitions.size());
        for (SDocumentListDefinition documentList : documentListDefinitions) {
            initialValuesExpressions.add(documentList.getExpression());
        }
        SExpressionContext currentExpressionContext = this.getsExpressionContext(processInstance, expressionContext, context);
        return this.expressionResolverService.evaluate(initialValuesExpressions, currentExpressionContext);
    }

    private SExpressionContext getsExpressionContext(SProcessInstance processInstance, SExpressionContext expressionContext, Map<String, Object> context) {
        SExpressionContext currentExpressionContext;
        if (expressionContext != null) {
            expressionContext.setInputValues(context);
            currentExpressionContext = expressionContext;
        } else {
            currentExpressionContext = new SExpressionContext((Long)processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), processInstance.getProcessDefinitionId());
            currentExpressionContext.setInputValues(context);
        }
        return currentExpressionContext;
    }

    protected SMappedDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url, long authorId, String description, int index) throws SObjectCreationException, SObjectAlreadyExistsException {
        SDocument attachment = BuilderFactory.get(SDocumentBuilderFactory.class).createNewExternalProcessDocumentReference(fileName, mimeType, authorId, url).done();
        return this.documentService.attachDocumentToProcessInstance(attachment, processInstanceId, documentName, description, index);
    }

    protected SMappedDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent, long authorId, String description, int index) throws SObjectCreationException, SObjectAlreadyExistsException {
        SDocument attachment = BuilderFactory.get(SDocumentBuilderFactory.class).createNewProcessDocument(fileName, mimeType, authorId, documentContent).done();
        return this.documentService.attachDocumentToProcessInstance(attachment, processInstanceId, documentName, description, index);
    }

    @Override
    public void childFinished(long processDefinitionId, long flowNodeInstanceId, long parentId) throws SBonitaException {
        SFlowNodeInstance sFlowNodeInstanceChild = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        SUserTaskInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        long processInstanceId = sFlowNodeInstanceChild.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex());
        SProcessInstance sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId);
        boolean isEnd = this.executeValidOutgoingTransitionsAndUpdateTokens(sProcessDefinition, sFlowNodeInstanceChild, sProcessInstance);
        this.logger.log(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG, "The flow node <" + sFlowNodeInstanceChild.getName() + "> with id<" + flowNodeInstanceId + "> of process instance <" + processInstanceId + "> finished");
        if (isEnd) {
            int numberOfFlowNode = this.activityInstanceService.getNumberOfFlowNodes(sProcessInstance.getId());
            if (sProcessInstance.getInterruptingEventId() > 0L) {
                --numberOfFlowNode;
            }
            if (numberOfFlowNode > 0) {
                if (this.logger.isLoggable(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG)) {
                    this.logger.log(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG, "The process instance <" + processInstanceId + "> from definition <" + sProcessDefinition.getName() + ":" + sProcessDefinition.getVersion() + "> executed a branch that is finished but there is still <" + numberOfFlowNode + "> to execute");
                    this.logger.log(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG, this.activityInstanceService.getFlowNodeInstances(processInstanceId, 0, numberOfFlowNode).toString());
                }
                return;
            }
            this.logger.log(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG, "The process instance <" + processInstanceId + "> from definition <" + sProcessDefinition.getName() + ":" + sProcessDefinition.getVersion() + "> finished");
            boolean hasActionsToExecute = false;
            if (ProcessInstanceState.ABORTING.getId() != sProcessInstance.getStateId()) {
                hasActionsToExecute = this.executePostThrowEventHandlers(sProcessDefinition, sProcessInstance, sFlowNodeInstanceChild);
                this.logger.log(ProcessExecutorImpl.class, TechnicalLogSeverity.DEBUG, "has action to execute");
                if (hasActionsToExecute) {
                    sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId);
                }
                this.eventsHandler.unregisterEventSubProcess(sProcessDefinition, sProcessInstance);
            }
            this.handleProcessCompletion(sProcessDefinition, sProcessInstance, hasActionsToExecute);
        }
    }

    @Override
    public void handleProcessCompletion(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, boolean hasActionsToExecute) throws SBonitaException {
        ProcessInstanceState processInstanceState;
        switch (sProcessInstance.getStateCategory()) {
            case ABORTING: {
                if (ProcessInstanceState.ABORTING.getId() == sProcessInstance.getStateId()) {
                    processInstanceState = ProcessInstanceState.ABORTED;
                    break;
                }
                if (hasActionsToExecute) {
                    processInstanceState = ProcessInstanceState.ABORTING;
                    break;
                }
                processInstanceState = ProcessInstanceState.ABORTED;
                break;
            }
            case CANCELLING: {
                processInstanceState = ProcessInstanceState.CANCELLED;
                break;
            }
            default: {
                processInstanceState = ProcessInstanceState.COMPLETING.getId() == sProcessInstance.getStateId() ? ProcessInstanceState.COMPLETED : (this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_FINISH, null) ? ProcessInstanceState.COMPLETING : ProcessInstanceState.COMPLETED);
            }
        }
        this.processInstanceService.setState(sProcessInstance, processInstanceState);
        this.flowNodeExecutor.childReachedState(sProcessInstance, processInstanceState, hasActionsToExecute);
    }

    private boolean executePostThrowEventHandlers(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SFlowNodeInstance child) throws SBonitaException {
        boolean hasActionsToExecute = false;
        if (sProcessInstance.hasBeenInterruptedByEvent()) {
            SFlowNodeInstance endEventInstance = this.activityInstanceService.getFlowNodeInstance(sProcessInstance.getInterruptingEventId());
            SEndEventDefinition endEventDefinition = (SEndEventDefinition)sProcessDefinition.getProcessContainer().getFlowNode(endEventInstance.getFlowNodeDefinitionId());
            hasActionsToExecute = this.eventsHandler.handlePostThrowEvent(sProcessDefinition, endEventDefinition, (SThrowEventInstance)endEventInstance, child);
            this.flowNodeExecutor.archiveFlowNodeInstance(endEventInstance, true, sProcessDefinition.getId());
        }
        return hasActionsToExecute;
    }

    private boolean executeValidOutgoingTransitionsAndUpdateTokens(SProcessDefinition processDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance) throws SBonitaException {
        SFlowNodeDefinition sFlowNodeDefinition = processDefinition.getProcessContainer().getFlowNode(child.getFlowNodeDefinitionId());
        FlowNodeTransitionsWrapper transitionsDescriptor = this.transitionEvaluator.buildTransitionsWrapper(sFlowNodeDefinition, processDefinition, child);
        this.archiveInvalidTransitions(child, transitionsDescriptor);
        ArrayList<STransitionDefinition> chosenGatewaysTransitions = new ArrayList<STransitionDefinition>(transitionsDescriptor.getValidOutgoingTransitionDefinitions().size());
        ArrayList<SFlowNodeDefinition> chosenFlowNode = new ArrayList<SFlowNodeDefinition>(transitionsDescriptor.getValidOutgoingTransitionDefinitions().size());
        for (STransitionDefinition sTransitionDefinition : transitionsDescriptor.getValidOutgoingTransitionDefinitions()) {
            SFlowNodeDefinition flowNodeDefinition = this.processDefinitionService.getNextFlowNode(processDefinition, sTransitionDefinition.getName());
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.TAKEN);
            if (flowNodeDefinition instanceof SGatewayDefinition) {
                chosenGatewaysTransitions.add(sTransitionDefinition);
                continue;
            }
            chosenFlowNode.add(flowNodeDefinition);
        }
        this.archiveFlowNodeInstance(processDefinition, child, sProcessInstance);
        long processInstanceId = sProcessInstance.getId();
        this.createAndExecuteActivities(processDefinition.getId(), child, processInstanceId, chosenFlowNode, child.getRootProcessInstanceId());
        for (STransitionDefinition sTransitionDefinition : chosenGatewaysTransitions) {
            this.executeGateway(processDefinition, sTransitionDefinition, child);
        }
        if (processDefinition.getProcessContainer().containsInclusiveGateway() && this.needToReevaluateInclusiveGateways(transitionsDescriptor)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "some branches died, will check again all inclusive gateways");
            List<SGatewayInstance> inclusiveGatewaysOfProcessInstance = this.gatewayInstanceService.getInclusiveGatewaysOfProcessInstanceThatShouldFire(processDefinition, processInstanceId);
            for (SGatewayInstance gatewayInstance : inclusiveGatewaysOfProcessInstance) {
                List<SGatewayInstance> otherMergedGateways = this.gatewayInstanceService.setFinishAndCreateNewGatewayForRemainingToken(processDefinition, gatewayInstance);
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinition.getId(), processInstanceId, gatewayInstance.getId(), null, null));
                if (otherMergedGateways == null) continue;
                for (SGatewayInstance otherMergedGateway : otherMergedGateways) {
                    this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinition.getId(), processInstanceId, otherMergedGateway.getId(), null, null));
                }
            }
        }
        return transitionsDescriptor.isLastFlowNode();
    }

    private void archiveFlowNodeInstance(SProcessDefinition sProcessDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance) throws SArchivingException {
        if (child.getId() != sProcessInstance.getInterruptingEventId() || SFlowNodeType.SUB_PROCESS.equals((Object)sProcessInstance.getCallerType())) {
            this.flowNodeExecutor.archiveFlowNodeInstance(child, true, sProcessDefinition.getId());
        }
    }

    private boolean needToReevaluateInclusiveGateways(FlowNodeTransitionsWrapper transitionsDescriptor) {
        int allOutgoingTransitions = transitionsDescriptor.getAllOutgoingTransitionDefinitions().size();
        int takenTransition = transitionsDescriptor.getValidOutgoingTransitionDefinitions().size();
        return takenTransition < allOutgoingTransitions;
    }

    private void archiveInvalidTransitions(SFlowNodeInstance child, FlowNodeTransitionsWrapper transitionsDescriptor) throws STransitionCreationException {
        for (STransitionDefinition sTransitionDefinition : transitionsDescriptor.getAllOutgoingTransitionDefinitions()) {
            if (transitionsDescriptor.getValidOutgoingTransitionDefinitions().contains(sTransitionDefinition)) continue;
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.ABORTED);
        }
    }

    @Override
    public SProcessInstance start(long starterId, long starterSubstituteId, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput, FlowNodeSelector selector) throws SProcessInstanceCreationException {
        return this.start(starterId, starterSubstituteId, null, operations, context, connectorsWithInput, -1L, selector);
    }

    @Override
    public SProcessInstance start(long processDefinitionId, long targetSFlowNodeDefinitionId, long starterId, long starterSubstituteId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput, long callerId, long subProcessDefinitionId) throws SProcessInstanceCreationException {
        try {
            SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
            FlowNodeSelector selector = new FlowNodeSelector(sProcessDefinition, this.getFilter(targetSFlowNodeDefinitionId), subProcessDefinitionId);
            return this.start(starterId, starterSubstituteId, expressionContext, operations, context, connectorsWithInput, callerId, selector);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessInstanceCreationException(e);
        }
    }

    private Filter<SFlowNodeDefinition> getFilter(long targetSFlowNodeDefinitionId) {
        if (targetSFlowNodeDefinitionId == -1L) {
            return new StartFlowNodeFilter();
        }
        return new FlowNodeIdFilter(targetSFlowNodeDefinitionId);
    }

    @Override
    public SProcessInstance start(long starterId, long starterSubstituteId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectors, long callerId, FlowNodeSelector selector) throws SProcessInstanceCreationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SProcessDefinition sProcessDefinition = selector.getProcessDefinition();
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), sProcessDefinition.getId());
            Thread.currentThread().setContextClassLoader(localClassLoader);
            try {
                localClassLoader.loadClass(this.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            SProcessInstance sProcessInstance = this.createProcessInstance(sProcessDefinition, starterId, starterSubstituteId, callerId);
            boolean isInitializing = this.initialize(starterId, sProcessDefinition, sProcessInstance, expressionContext, operations != null ? new ArrayList<SOperation>(operations) : null, context, selector.getContainer(), connectors, selector);
            try {
                this.handleEventSubProcess(sProcessDefinition, sProcessInstance, selector.getSubProcessDefinitionId());
            }
            catch (SProcessInstanceCreationException e) {
                throw e;
            }
            catch (SBonitaException e) {
                this.setExceptionContext(sProcessDefinition, sProcessInstance, e);
                throw new SProcessInstanceCreationException("Unable to register events for event sub process in process.", e);
            }
            if (isInitializing) {
                this.processInstanceService.setState(sProcessInstance, ProcessInstanceState.INITIALIZING);
                SProcessInstance sProcessInstance2 = sProcessInstance;
                return sProcessInstance2;
            }
            SProcessInstance sProcessInstance3 = this.startElements(sProcessInstance, selector);
            return sProcessInstance3;
        }
        catch (BonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (IOException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (SProcessInstanceCreationException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, List<ConnectorDefinitionWithInputValues> connectorsList) throws InvalidEvaluationConnectorConditionException, SConnectorException {
        SExpressionContext expcontext = new SExpressionContext();
        expcontext.setProcessDefinitionId(processDefinition.getId());
        expcontext.setProcessDefinition(processDefinition);
        expcontext.setContainerId(sProcessInstance.getId());
        expcontext.setContainerType(DataInstanceContainer.PROCESS_INSTANCE.name());
        for (ConnectorDefinitionWithInputValues connectorWithInput : connectorsList) {
            ConnectorDefinition connectorDefinition = connectorWithInput.getConnectorDefinition();
            Map contextInputValues = connectorWithInput.getInputValues();
            String connectorId = connectorDefinition.getConnectorId();
            String version = connectorDefinition.getVersion();
            Map inputs = connectorDefinition.getInputs();
            if (contextInputValues.size() != inputs.size()) {
                throw new InvalidEvaluationConnectorConditionException(contextInputValues.size(), inputs.size());
            }
            Map<String, SExpression> connectorsExps = ModelConvertor.constructExpressions(inputs);
            ConnectorResult result = this.connectorService.executeMutipleEvaluation(processDefinition.getId(), connectorId, version, connectorsExps, contextInputValues, Thread.currentThread().getContextClassLoader(), expcontext);
            List outputs = connectorDefinition.getOutputs();
            this.connectorService.executeOutputOperation(ModelConvertor.convertOperations(outputs), expcontext, result);
        }
    }

    protected void handleEventSubProcess(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, long subProcessDefinitionId) throws SBonitaException {
        if (subProcessDefinitionId == -1L) {
            this.eventsHandler.handleEventSubProcess(sProcessDefinition, sProcessInstance);
        }
    }

    @Override
    public SProcessInstance startElements(SProcessInstance sProcessInstance, FlowNodeSelector selector) throws SProcessInstanceCreationException, SFlowNodeExecutionException {
        List<SFlowNodeInstance> flowNodeInstances = this.initializeFirstExecutableElements(sProcessInstance, selector);
        int size = flowNodeInstances.size();
        ProcessInstanceState state = size == 0 ? ProcessInstanceState.COMPLETED : ProcessInstanceState.STARTED;
        try {
            this.processInstanceService.setState(sProcessInstance, state);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException("Unable to set the state on the process.", e);
        }
        for (SFlowNodeInstance sFlowNodeInstance : flowNodeInstances) {
            try {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sProcessInstance.getProcessDefinitionId(), sProcessInstance.getId(), sFlowNodeInstance.getId(), null, null));
            }
            catch (SWorkRegisterException e) {
                this.setExceptionContext(sProcessInstance, sFlowNodeInstance, (SBonitaException)e);
                throw new SFlowNodeExecutionException("Unable to trigger execution of the flow node.", e);
            }
        }
        return sProcessInstance;
    }

    @Override
    public String getHandledType() {
        return SFlowElementsContainerType.PROCESS.name();
    }

    private void createAndExecuteActivities(Long processDefinitionId, SFlowNodeInstance flowNodeInstance, long parentProcessInstanceId, List<SFlowNodeDefinition> choosenActivityDefinitions, long rootProcessInstanceId) throws SBonitaException {
        SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        SStateCategory stateCategory = parentProcessInstance.getStateCategory();
        List<SFlowNodeInstance> sFlowNodeInstances = this.bpmInstancesCreator.createFlowNodeInstances(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getParentContainerId(), choosenActivityDefinitions, rootProcessInstanceId, parentProcessInstanceId, stateCategory);
        for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, parentProcessInstanceId, sFlowNodeInstance.getId(), null, null));
        }
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        this.setExceptionContext(sProcessDefinition, e);
        e.setProcessInstanceIdOnContext(sFlowNodeInstance.getParentProcessInstanceId());
        e.setRootProcessInstanceIdOnContext(sFlowNodeInstance.getRootProcessInstanceId());
        this.setExceptionContext(sFlowNodeInstance, e);
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SBonitaException e) {
        this.setExceptionContext(sProcessDefinition, e);
        this.setExceptionContext(sProcessInstance, e);
    }

    private void setExceptionContext(SProcessInstance sProcessInstance, SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        e.setProcessDefinitionIdOnContext(sProcessInstance.getProcessDefinitionId());
        e.setProcessDefinitionNameOnContext(sProcessInstance.getName());
        this.setExceptionContext(sProcessInstance, e);
        this.setExceptionContext(sFlowNodeInstance, e);
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SBonitaException e) {
        e.setProcessDefinitionIdOnContext(sProcessDefinition.getId());
        e.setProcessDefinitionNameOnContext(sProcessDefinition.getName());
        e.setProcessDefinitionVersionOnContext(sProcessDefinition.getVersion());
    }

    private void setExceptionContext(SProcessInstance sProcessInstance, SBonitaException e) {
        e.setProcessInstanceIdOnContext(sProcessInstance.getId());
        e.setRootProcessInstanceIdOnContext(sProcessInstance.getRootProcessInstanceId());
    }

    private void setExceptionContext(SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        e.setFlowNodeDefinitionIdOnContext(sFlowNodeInstance.getFlowNodeDefinitionId());
        e.setFlowNodeInstanceIdOnContext(sFlowNodeInstance.getId());
        e.setFlowNodeNameOnContext(sFlowNodeInstance.getName());
    }
}

