/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.TransactionContainedProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public abstract class EndingCallActivityExceptionStateImpl
implements FlowNodeState {
    private final ActivityInstanceService activityInstanceService;
    private final ProcessInstanceService processInstanceService;
    private final ContainerRegistry containerRegistry;
    private final ArchiveService archiveService;
    private final SCommentService commentService;
    private final DataInstanceService dataInstanceService;
    private final DocumentService documentService;
    private final TechnicalLoggerService logger;
    private final ProcessDefinitionService processDefinitionService;
    private final ConnectorInstanceService connectorInstanceService;
    private ClassLoaderService classLoaderService;

    public EndingCallActivityExceptionStateImpl(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, ContainerRegistry containerRegistry, ArchiveService archiveService, SCommentService commentService, DataInstanceService dataInstanceService, DocumentService documentService, TechnicalLoggerService logger, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.containerRegistry = containerRegistry;
        this.archiveService = archiveService;
        this.commentService = commentService;
        this.dataInstanceService = dataInstanceService;
        this.documentService = documentService;
        this.logger = logger;
        this.processDefinitionService = processDefinitionService;
        this.connectorInstanceService = connectorInstanceService;
        this.classLoaderService = classLoaderService;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        try {
            boolean hasActiveChild;
            SCallActivityInstance callActivity = (SCallActivityInstance)flowNodeInstance;
            boolean bl = hasActiveChild = callActivity.getTokenCount() > 0;
            if (hasActiveChild) {
                SProcessInstance targetProcessInstance = this.processInstanceService.getChildOfActivity(flowNodeInstance.getId());
                TransactionContainedProcessInstanceInterruptor processInstanceInterruptor = new TransactionContainedProcessInstanceInterruptor(this.processInstanceService, this.activityInstanceService, this.containerRegistry, this.logger);
                processInstanceInterruptor.interruptProcessInstance(targetProcessInstance.getId(), this.getStateCategory(), -1L);
            } else {
                this.archiveChildProcessInstance(flowNodeInstance);
            }
            return hasActiveChild;
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance instance) throws SActivityStateExecutionException {
        try {
            this.archiveChildProcessInstance(instance);
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("Unable to found the process instance called by call activity with id " + instance.getId(), e);
        }
        return StateCode.DONE;
    }

    protected void archiveChildProcessInstance(SFlowNodeInstance instance) throws SProcessInstanceNotFoundException, SArchivingException, SBonitaReadException {
        SProcessInstance childProcInst = this.processInstanceService.getChildOfActivity(instance.getId());
        ProcessArchiver.archiveProcessInstance(childProcInst, this.archiveService, this.processInstanceService, this.dataInstanceService, this.documentService, this.logger, this.commentService, this.processDefinitionService, this.connectorInstanceService, this.classLoaderService);
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }
}

