/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl.condition;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.impl.condition.BinaryComparator;
import org.bonitasoft.engine.expression.impl.condition.BinaryComparatorMapper;
import org.bonitasoft.engine.expression.impl.condition.SComparisonException;
import org.bonitasoft.engine.expression.model.SExpression;

public class BinaryComparatorExecutor {
    private final BinaryComparatorMapper mapper;
    private final Set<String> numericTypes;

    public BinaryComparatorExecutor(BinaryComparatorMapper mapper) {
        this.mapper = mapper;
        this.numericTypes = new HashSet<String>();
        this.numericTypes.add(Integer.class.getName());
        this.numericTypes.add(Long.class.getName());
        this.numericTypes.add(Double.class.getName());
        this.numericTypes.add(Float.class.getName());
        this.numericTypes.add(Short.class.getName());
        this.numericTypes.add(Byte.class.getName());
        this.numericTypes.add(Integer.TYPE.getName());
        this.numericTypes.add(Long.TYPE.getName());
        this.numericTypes.add(Double.TYPE.getName());
        this.numericTypes.add(Float.TYPE.getName());
        this.numericTypes.add(Short.TYPE.getName());
        this.numericTypes.add(Byte.TYPE.getName());
    }

    public Boolean evaluate(Map<Integer, Object> resolvedExpressions, SExpression expression) throws SExpressionEvaluationException {
        this.validate(expression);
        BinaryComparator evaluator = this.mapper.getEvaluator(expression.getContent());
        if (evaluator == null) {
            throw new SExpressionEvaluationException("Unable to find evaluator for operator '" + expression.getContent() + "'", expression.getName());
        }
        SExpression leftExpression = expression.getDependencies().get(0);
        SExpression rightExpression = expression.getDependencies().get(1);
        Object resolvedLeftExpr = this.transtypeIfApplicable(leftExpression.getReturnType(), resolvedExpressions.get(leftExpression.getDiscriminant()));
        Object resolvedRightExpr = this.transtypeIfApplicable(rightExpression.getReturnType(), resolvedExpressions.get(rightExpression.getDiscriminant()));
        try {
            return evaluator.evaluate(resolvedLeftExpr, resolvedRightExpr);
        }
        catch (SComparisonException e) {
            throw new SExpressionEvaluationException("Unable to evaluate expression '" + expression.getName() + "'", e, expression.getName());
        }
    }

    protected Object transtypeIfApplicable(String type, Object object) {
        if (object == null) {
            return null;
        }
        if (this.numericTypes.contains(type)) {
            return new BigDecimal(String.valueOf(object));
        }
        return object;
    }

    private void validate(SExpression expression) throws SExpressionEvaluationException {
        this.validateNumberOfDependencies(expression);
        this.validateReturnType(expression);
    }

    private void validateReturnType(SExpression expression) throws SExpressionEvaluationException {
        List<SExpression> dependencies = expression.getDependencies();
        if (!this.areReturnTypeCompatible(dependencies.get(0).getReturnType(), dependencies.get(1).getReturnType(), expression.getContent())) {
            throw new SExpressionEvaluationException("The two dependencies of expression '" + expression.getContent() + "' must have the same return type.", expression.getName());
        }
    }

    private void validateNumberOfDependencies(SExpression expression) throws SExpressionEvaluationException {
        int expectedNbOfDep = 2;
        int actualNbOfDep = expression.getDependencies().size();
        if (actualNbOfDep != expectedNbOfDep) {
            StringBuilder stb = new StringBuilder();
            stb.append("The expression '");
            stb.append(expression.getContent());
            stb.append("' has ");
            stb.append(actualNbOfDep);
            stb.append(" dependencies, but it must have exactly ");
            stb.append(expectedNbOfDep);
            stb.append(" dependencies.");
            throw new SExpressionEvaluationException(stb.toString(), expression.getName());
        }
    }

    protected boolean areReturnTypeCompatible(String leftReturnType, String rightReturnType, String content) {
        return this.numericTypes.contains(leftReturnType) && this.numericTypes.contains(rightReturnType) || leftReturnType.equals(rightReturnType) || "==".equals(content);
    }
}

