/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.comment.transaction;

import java.util.List;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.AbstractCommentSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;

public class SearchCommentsSupervisedByTransaction
extends AbstractCommentSearchEntity {
    private final SCommentService commentService;
    private final Long supervisorId;

    public SearchCommentsSupervisedByTransaction(Long supervisorId, SCommentService commentService, SearchEntityDescriptor searchDescriptor, SearchOptions searchOptions) {
        super(searchDescriptor, searchOptions);
        this.supervisorId = supervisorId;
        this.commentService = commentService;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaReadException {
        return this.commentService.getNumberOfCommentsSupervisedBy(this.supervisorId, searchOptions);
    }

    @Override
    public List<SComment> executeSearch(QueryOptions searchOptions) throws SBonitaReadException {
        return this.commentService.searchCommentsSupervisedBy(this.supervisorId, searchOptions);
    }
}

