/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.profile.command;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.profile.ImportPolicy;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.ProfilesImporter;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.xml.Parser;

public class ImportProfilesCommand
extends TenantCommand {
    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        byte[] xmlContent;
        ProfileService profileService = serviceAccessor.getProfileService();
        IdentityService identityService = serviceAccessor.getIdentityService();
        try {
            xmlContent = (byte[])parameters.get("xmlContent");
            if (xmlContent == null) {
                throw new SCommandParameterizationException("Parameters map must contain an entry  xmlContent with a byte array value.");
            }
        }
        catch (Exception e) {
            throw new SCommandParameterizationException("Parameters map must contain an entry  xmlContent with a byte array value.", e);
        }
        Parser parser = serviceAccessor.getProfileParser();
        try {
            List<ExportedProfile> profiles = ProfilesImporter.getProfilesFromXML(new String(xmlContent), parser);
            return (Serializable)((Object)ProfilesImporter.toWarnings(new ProfilesImporter(profileService, identityService, profiles, ImportPolicy.DELETE_EXISTING).importProfiles(SessionInfos.getUserIdFromSession())));
        }
        catch (ExecutionException e) {
            throw new SCommandExecutionException(e);
        }
        catch (IOException e) {
            throw new SCommandExecutionException(e);
        }
    }
}

