/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.identity.CustomUserInfoDefinitionCreator;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionAlreadyExistsException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionCreationException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionBuilder;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionBuilderFactory;
import org.bonitasoft.engine.identity.xml.ImportDuplicateInOrganizationException;
import org.bonitasoft.engine.identity.xml.ImportOrganizationStrategy;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class CustomUserInfoDefinitionImporter {
    private final IdentityService identityService;
    private final ImportOrganizationStrategy strategy;

    public CustomUserInfoDefinitionImporter(TenantServiceAccessor serviceAccessor, ImportOrganizationStrategy strategy) {
        this.strategy = strategy;
        this.identityService = serviceAccessor.getIdentityService();
    }

    public Map<String, SCustomUserInfoDefinition> importCustomUserInfoDefinitions(List<CustomUserInfoDefinitionCreator> userInfoDefinitionCreators) throws SIdentityException, ImportDuplicateInOrganizationException {
        HashMap<String, SCustomUserInfoDefinition> nameToDefinition = new HashMap<String, SCustomUserInfoDefinition>(userInfoDefinitionCreators.size());
        for (CustomUserInfoDefinitionCreator creator : userInfoDefinitionCreators) {
            String name = creator.getName();
            SCustomUserInfoDefinition userInfoDef = null;
            if (this.identityService.hasCustomUserInfoDefinition(name)) {
                userInfoDef = this.identityService.getCustomUserInfoDefinitionByName(name);
                this.strategy.foundExistingCustomUserInfoDefinition(userInfoDef, creator);
            } else {
                userInfoDef = this.addCustomUserInfoDefinition(creator);
            }
            nameToDefinition.put(name, userInfoDef);
        }
        return nameToDefinition;
    }

    private SCustomUserInfoDefinition addCustomUserInfoDefinition(CustomUserInfoDefinitionCreator creator) throws SCustomUserInfoDefinitionAlreadyExistsException, SCustomUserInfoDefinitionCreationException {
        SCustomUserInfoDefinitionBuilder userInfoBuilder = BuilderFactory.get(SCustomUserInfoDefinitionBuilderFactory.class).createNewInstance();
        userInfoBuilder.setName(creator.getName());
        userInfoBuilder.setDescription(creator.getDescription());
        return this.identityService.createCustomUserInfoDefinition(userInfoBuilder.done());
    }
}

