/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.impl.AbstractQuartzJobListener;
import org.bonitasoft.engine.scheduler.impl.BonitaTransactionSynchronizationImpl;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TenantQuartzJobListener
extends AbstractQuartzJobListener {
    private final SessionAccessor sessionAccessor;
    private final TransactionService transactionService;
    private final TechnicalLoggerService logger;
    private final List<AbstractBonitaTenantJobListener> bonitaJobListeners;
    private final String groupName;

    public TenantQuartzJobListener(List<AbstractBonitaTenantJobListener> bonitaJobListeners, String groupName, SessionAccessor sessionAccessor, TransactionService transactionService, TechnicalLoggerService logger) {
        this.logger = logger;
        this.bonitaJobListeners = bonitaJobListeners;
        this.groupName = groupName;
        this.sessionAccessor = sessionAccessor;
        this.transactionService = transactionService;
    }

    public String getName() {
        return "TenantQuartzJobListener_" + this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobToBeExecuted(JobExecutionContext context) {
        Map<String, Serializable> mapContext = this.buildMapContext(context);
        Long tenantId = Long.valueOf(this.groupName);
        try {
            this.sessionAccessor.setTenantId(tenantId);
            for (AbstractBonitaTenantJobListener abstractBonitaTenantJobListener : this.bonitaJobListeners) {
                abstractBonitaTenantJobListener.jobToBeExecuted(mapContext);
            }
        }
        finally {
            this.cleanSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobExecutionVetoed(JobExecutionContext context) {
        Map<String, Serializable> mapContext = this.buildMapContext(context);
        Long tenantId = Long.valueOf(this.groupName);
        try {
            this.sessionAccessor.setTenantId(tenantId);
            for (AbstractBonitaTenantJobListener abstractBonitaTenantJobListener : this.bonitaJobListeners) {
                abstractBonitaTenantJobListener.jobExecutionVetoed(mapContext);
            }
        }
        finally {
            this.cleanSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Map<String, Serializable> mapContext = this.buildMapContext(context);
        Long tenantId = Long.valueOf(this.groupName);
        try {
            this.sessionAccessor.setTenantId(tenantId);
            for (AbstractBonitaTenantJobListener abstractBonitaTenantJobListener : this.bonitaJobListeners) {
                abstractBonitaTenantJobListener.jobWasExecuted(mapContext, (Exception)jobException);
            }
        }
        finally {
            this.cleanSession();
        }
    }

    private void cleanSession() {
        block2: {
            try {
                this.transactionService.registerBonitaSynchronization(new BonitaTransactionSynchronizationImpl(this.sessionAccessor));
            }
            catch (STransactionNotFoundException e) {
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block2;
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
            }
        }
    }
}

