/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.actor.mapping.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorCreationException;
import org.bonitasoft.engine.actor.mapping.SActorDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberCreationException;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.SActorUpdateException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorLogBuilder;
import org.bonitasoft.engine.actor.mapping.model.SActorLogBuilderFactory;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.mapping.model.impl.SActorMemberImpl;
import org.bonitasoft.engine.actor.mapping.persistence.SelectDescriptorBuilder;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class ActorMappingServiceImpl
implements ActorMappingService {
    private static final int BATCH_SIZE = 100;
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final QueriableLoggerService queriableLoggerService;
    private final IdentityService identityService;

    public ActorMappingServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, QueriableLoggerService queriableLoggerService, IdentityService identityService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.queriableLoggerService = queriableLoggerService;
        this.identityService = identityService;
    }

    @Override
    public Set<SActor> addActors(Set<SActor> actors) throws SActorCreationException {
        HashSet<SActor> sActors = new HashSet<SActor>();
        for (SActor actor : actors) {
            sActors.add(this.addActor(actor));
        }
        return sActors;
    }

    @Override
    public SActor addActor(SActor actor) throws SActorCreationException {
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a new actor");
        InsertRecord insertRecord = new InsertRecord(actor);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("ACTOR", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("ACTOR").setObject(actor).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(actor.getId(), 1, logBuilder, "addActor");
            return actor;
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(actor.getId(), 0, logBuilder, "addActor");
            throw new SActorCreationException(re);
        }
    }

    private SActorLogBuilder getQueriableLog(ActionType actionType, String message) {
        SActorLogBuilder logBuilder = BuilderFactory.get(SActorLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public SActor getActor(long actorId) throws SActorNotFoundException, SBonitaReadException {
        SelectByIdDescriptor<SActor> selectByIdDescriptor = SelectDescriptorBuilder.getActor(actorId);
        SActor actor = this.persistenceService.selectById(selectByIdDescriptor);
        if (actor == null) {
            throw new SActorNotFoundException(actorId + " does not refer to any actor");
        }
        return actor;
    }

    @Override
    public long getNumberOfUsersOfActor(long actorId) {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfUsersOfActor(actorId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException bre) {
            throw new RuntimeException(bre);
        }
    }

    @Override
    public long getNumberOfRolesOfActor(long actorId) {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfRolesOfActor(actorId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException bre) {
            throw new RuntimeException(bre);
        }
    }

    @Override
    public long getNumberOfGroupsOfActor(long actorId) {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfGroupsOfActor(actorId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException bre) {
            throw new RuntimeException(bre);
        }
    }

    @Override
    public long getNumberOfMembershipsOfActor(long actorId) {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfMembershipsOfActor(actorId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException bre) {
            throw new RuntimeException(bre);
        }
    }

    @Override
    public List<SActor> getActors(List<Long> actorIds) throws SBonitaReadException {
        if (actorIds == null || actorIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SActor.class, "Actor", actorIds));
    }

    @Override
    public SActor getActor(String actorName, long scopeId) throws SActorNotFoundException {
        SelectOneDescriptor<SActor> selectOneDescriptor = SelectDescriptorBuilder.getActor(actorName, scopeId);
        try {
            SActor actor = this.persistenceService.selectOne(selectOneDescriptor);
            if (actor == null) {
                throw new SActorNotFoundException("Actor not found with name: " + actorName + " of scopeId: " + scopeId);
            }
            return actor;
        }
        catch (SBonitaReadException bre) {
            throw new SActorNotFoundException(bre);
        }
    }

    @Override
    public SActor updateActor(long actorId, EntityUpdateDescriptor descriptor) throws SActorNotFoundException, SActorUpdateException, SBonitaReadException {
        SActor actor = this.getActor(actorId);
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating an actor");
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)actor, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("ACTOR", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTOR").setObject(actor).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(actorId, 1, logBuilder, "updateActor");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(actorId, 0, logBuilder, "updateActor");
            throw new SActorUpdateException(e);
        }
        return actor;
    }

    @Override
    public void deleteActors(long scopeId) throws SActorDeletionException {
        try {
            QueryOptions queryOptions = new QueryOptions(0, 100, SActor.class, "id", OrderByType.ASC);
            List<SActor> actors = this.getActors(scopeId, queryOptions);
            while (!actors.isEmpty()) {
                for (SActor actor : actors) {
                    this.deleteActorMembers(actor);
                    this.deleteActor(actor);
                }
                actors = this.getActors(scopeId, queryOptions);
            }
        }
        catch (SBonitaReadException bre) {
            throw new SActorDeletionException(bre);
        }
        catch (SActorMemberDeletionException e) {
            throw new SActorDeletionException(e);
        }
    }

    private void deleteActorMembers(SActor actor) throws SBonitaReadException, SActorMemberDeletionException {
        List<SActorMember> actorMembers;
        do {
            actorMembers = this.getActorMembers(actor.getId(), 0, 100);
            for (SActorMember sActorMember : actorMembers) {
                this.deleteActorMember(sActorMember);
            }
        } while (actorMembers.size() > 0);
    }

    private void deleteActor(SActor actor) throws SActorDeletionException {
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting an actor");
        DeleteRecord deleteRecord = new DeleteRecord(actor);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("ACTOR", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("ACTOR").setObject(actor).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(actor.getId(), 1, logBuilder, "deleteActor");
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(actor.getId(), 0, logBuilder, "deleteActor");
            throw new SActorDeletionException(re);
        }
    }

    @Override
    public List<SActor> getActors(Set<Long> scopeIds, Long userId) throws SBonitaReadException {
        SelectListDescriptor<SActor> descriptor = SelectDescriptorBuilder.getFullActorsListOfUser(scopeIds, userId);
        return this.persistenceService.selectList(descriptor);
    }

    @Override
    public SActorMember addUserToActor(long actorId, long userId) throws SActorMemberCreationException {
        SActorMemberImpl actorMember = new SActorMemberImpl();
        actorMember.setActorId(actorId);
        actorMember.setUserId(userId);
        return this.addActorMember(actorMember);
    }

    private SActorMember addActorMember(SActorMemberImpl actorMember) throws SActorMemberCreationException {
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a new actor member");
        InsertRecord insertRecord = new InsertRecord(actorMember);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("ACTOR_MEMBER", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("ACTOR_MEMBER").setObject(actorMember).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(actorMember.getId(), 1, logBuilder, "addActorMember");
            return actorMember;
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(actorMember.getId(), 0, logBuilder, "addActorMember");
            throw new SActorMemberCreationException(re);
        }
    }

    @Override
    public SActorMember addGroupToActor(long actorId, long groupId) throws SActorNotFoundException, SActorMemberCreationException {
        try {
            List<SGroup> groupChildren;
            SActorMember addActorMember = this.addOnlyThisGroupToActor(actorId, groupId);
            int i = 0;
            do {
                groupChildren = this.identityService.getGroupChildren(groupId, i, 100);
                for (SGroup child : groupChildren) {
                    if (this.getNumberOfActorMembersOfGroupWithActor(child.getId(), actorId) != 0L) continue;
                    this.addGroupToActor(actorId, child.getId());
                }
                i += 100;
            } while (groupChildren.size() == 100);
            return addActorMember;
        }
        catch (SIdentityException e) {
            throw new SActorMemberCreationException(e);
        }
        catch (SBonitaReadException e) {
            throw new SActorMemberCreationException(e);
        }
    }

    private SActorMember addOnlyThisGroupToActor(long actorId, long groupId) throws SActorMemberCreationException {
        SActorMemberImpl actorMember = new SActorMemberImpl();
        actorMember.setActorId(actorId);
        actorMember.setGroupId(groupId);
        return this.addActorMember(actorMember);
    }

    @Override
    public SActorMember addRoleToActor(long actorId, long roleId) throws SActorMemberCreationException {
        SActorMemberImpl actorMember = new SActorMemberImpl();
        actorMember.setActorId(actorId);
        actorMember.setRoleId(roleId);
        return this.addActorMember(actorMember);
    }

    @Override
    public SActorMember addRoleAndGroupToActor(long actorId, long roleId, long groupId) throws SActorNotFoundException, SActorMemberCreationException {
        try {
            List<SGroup> groupChildren;
            SActorMember addActorMember = this.addOnlyThisRoleAndGroupToActor(actorId, roleId, groupId);
            int i = 0;
            do {
                groupChildren = this.identityService.getGroupChildren(groupId, i, 100);
                for (SGroup child : groupChildren) {
                    this.addRoleAndGroupToActor(actorId, roleId, child.getId());
                }
                i += 100;
            } while (groupChildren.size() == 100);
            return addActorMember;
        }
        catch (SIdentityException e) {
            throw new SActorMemberCreationException(e);
        }
    }

    private SActorMember addOnlyThisRoleAndGroupToActor(long actorId, long roleId, long groupId) throws SActorMemberCreationException {
        SActorMemberImpl actorMember = new SActorMemberImpl();
        actorMember.setActorId(actorId);
        actorMember.setRoleId(roleId);
        actorMember.setGroupId(groupId);
        return this.addActorMember(actorMember);
    }

    @Override
    public SActorMember deleteActorMember(long actorMemberId) throws SActorMemberNotFoundException, SActorMemberDeletionException {
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting an actor member");
        try {
            SActorMember actorMember = this.getActorMember(actorMemberId);
            this.deleteActorMember(actorMember);
            return actorMember;
        }
        catch (SBonitaReadException e) {
            this.initiateLogBuilder(actorMemberId, 0, logBuilder, "removeActorMember");
            throw new SActorMemberDeletionException(e);
        }
    }

    @Override
    public void deleteActorMember(SActorMember sActorMember) throws SActorMemberDeletionException {
        SActorLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting an actor member");
        long actorMemberId = sActorMember.getId();
        try {
            DeleteRecord deleteRecord = new DeleteRecord(sActorMember);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("ACTOR_MEMBER", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("ACTOR_MEMBER").setObject(sActorMember).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(actorMemberId, 1, logBuilder, "removeActorMember");
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(actorMemberId, 0, logBuilder, "removeActorMember");
            throw new SActorMemberDeletionException(re);
        }
    }

    private SActorMember getActorMember(long actorMemberId) throws SActorMemberNotFoundException, SBonitaReadException {
        SelectByIdDescriptor<SActorMember> selectByIdDescriptor = SelectDescriptorBuilder.getActorMember(actorMemberId);
        SActorMember actor = this.persistenceService.selectById(selectByIdDescriptor);
        if (actor == null) {
            throw new SActorMemberNotFoundException(actorMemberId + " does not refer to any actor member");
        }
        return actor;
    }

    @Override
    public SActorMember getActorMember(long actorId, long userId, long groupId, long roleId) throws SBonitaReadException {
        SelectOneDescriptor<SActorMember> descriptor = SelectDescriptorBuilder.getActorMember(actorId, userId, groupId, roleId);
        return this.persistenceService.selectOne(descriptor);
    }

    @Override
    public long getNumberOfActorMembers(long actorId) throws SBonitaReadException {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfActorMembers(actorId);
        return this.persistenceService.selectOne(descriptor);
    }

    @Override
    public List<SActorMember> getActorMembers(long actorId, int fromIndex, int numberOfActorMembers) throws SBonitaReadException {
        SelectListDescriptor<SActorMember> descriptor = SelectDescriptorBuilder.getActorMembers(actorId, fromIndex, numberOfActorMembers);
        return this.persistenceService.selectList(descriptor);
    }

    @Override
    public List<SActorMember> getActorMembersOfUser(long userId, int fromIndex, int numberOfActorMembers) throws SBonitaReadException {
        SelectListDescriptor<SActorMember> descriptor = SelectDescriptorBuilder.getActorMembersOfUser(userId, fromIndex, numberOfActorMembers);
        return this.persistenceService.selectList(descriptor);
    }

    @Override
    public List<SActorMember> getActorMembersOfGroup(long groupId, int fromIndex, int numberOfActorMembers) throws SBonitaReadException {
        SelectListDescriptor<SActorMember> descriptor = SelectDescriptorBuilder.getActorMembersOfGroup(groupId, fromIndex, numberOfActorMembers);
        return this.persistenceService.selectList(descriptor);
    }

    private long getNumberOfActorMembersOfGroupWithActor(long groupId, long actorId) throws SBonitaReadException {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfActorMembersOfGroupWithActor(groupId, actorId);
        return this.persistenceService.selectOne(descriptor);
    }

    @Override
    public List<SActorMember> getActorMembersOfRole(long roleId, int fromIndex, int numberOfActorMembers) throws SBonitaReadException {
        SelectListDescriptor<SActorMember> descriptor = SelectDescriptorBuilder.getActorMembersOfRole(roleId, fromIndex, numberOfActorMembers);
        return this.persistenceService.selectList(descriptor);
    }

    @Override
    public boolean canUserStartProcessDefinition(long userId, long processDefinitionId) throws SBonitaReadException {
        SelectListDescriptor<Long> descriptor = SelectDescriptorBuilder.getActorMembersInitiatorForProcess(processDefinitionId, 0, Integer.MAX_VALUE);
        List<Long> actorMembersForProcess = this.persistenceService.selectList(descriptor);
        int BATCH_SIZE = 80;
        boolean found = false;
        while (!found && actorMembersForProcess.size() > 0) {
            found = 0L < this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUserMembersForUserOrManagerForActorMembers(userId, this.retrieveFirstResultsAndRemoveFromOriginalList(80, actorMembersForProcess)));
        }
        return found;
    }

    private List<Long> retrieveFirstResultsAndRemoveFromOriginalList(int howMany, List<Long> ids) {
        ArrayList<Long> subList = new ArrayList<Long>(howMany);
        for (int i = 0; i < howMany && ids.size() > 0; ++i) {
            subList.add(ids.remove(0));
        }
        return subList;
    }

    @Override
    public List<SActor> getActors(long processDefinitionId, QueryOptions queryOptions) throws SBonitaReadException {
        SelectListDescriptor<SActor> descriptor = SelectDescriptorBuilder.getActorsOfScope(processDefinitionId, queryOptions);
        return this.persistenceService.selectList(descriptor);
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    @Override
    public void deleteAllActorMembers() throws SActorMemberDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SActorMember.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SActorMemberDeletionException("Can't delete all actor members.", e);
        }
    }

    @Override
    public List<Long> getPossibleUserIdsOfActorId(long actorId, int startIndex, int maxResults) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        SelectListDescriptor descriptor = new SelectListDescriptor("getPossibleUserIdsOfActorId", parameters, SActor.class, new QueryOptions(startIndex, maxResults));
        return this.persistenceService.selectList(descriptor);
    }
}

